/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.inject.internal.Lists;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ui.StorageTypedElement;
import org.eclipse.xtext.util.Strings;

public class CompareInputResourceProvider
implements IResourceProvider {
    private ICompareInput compareInput;
    private ITypedElement typedElement;

    public CompareInputResourceProvider(ICompareInput compareInput, ITypedElement typedElement) {
        Assert.isNotNull((Object)compareInput, (String)"parameter 'compareInput' must not be null");
        Assert.isNotNull((Object)typedElement, (String)"parameter 'typedElement' must not be null");
        this.compareInput = compareInput;
        this.typedElement = typedElement;
    }

    public IResource getResource() {
        IResource resource = this.getResource(this.typedElement);
        if (resource == null) {
            resource = this.typedElement == this.compareInput.getLeft() ? this.getResource(this.compareInput.getRight()) : this.getResource(this.compareInput.getLeft());
        }
        if (resource == null && this.compareInput instanceof ITypedElement) {
            resource = this.getResource((ITypedElement)this.compareInput);
        }
        return resource;
    }

    protected IResource getResource(ITypedElement typedElement) {
        IResource result = null;
        if (typedElement instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)typedElement;
            result = resourceProvider.getResource();
        } else if (typedElement instanceof StorageTypedElement) {
            StorageTypedElement storageTypedElement = (StorageTypedElement)typedElement;
            IStorage bufferedStorage = storageTypedElement.getBufferedStorage();
            result = this.getExistingFile((IPath)(bufferedStorage != null ? bufferedStorage.getFullPath() : Path.EMPTY));
        }
        if (result == null) {
            Object[] path = this.getPath(typedElement, 0);
            int i = 0;
            while (i < path.length && result == null) {
                IProject project = this.getWorkspaceRoot().getProject(path[i]);
                if (project.exists()) {
                    String concatenatedPath = Strings.concat((String)String.valueOf('/'), Lists.newArrayList((Object[])path).subList(i, path.length));
                    result = this.getExistingFile((IPath)new Path(concatenatedPath));
                }
                ++i;
            }
        }
        return result;
    }

    private IResource getExistingFile(IPath fullPath) {
        IFile file = this.getWorkspaceRoot().getFile(fullPath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String[] getPath(ITypedElement typedElement, int level) {
        IDiffContainer parent;
        String[] path = null;
        if (typedElement instanceof IDiffContainer && (parent = ((IDiffContainer)typedElement).getParent()) != null) {
            path = this.getPath((ITypedElement)parent, level + 1);
        }
        if (path == null) {
            path = new String[level + 1];
        }
        path[path.length - 1 - level] = typedElement.getName();
        return path;
    }
}

