/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.xtext.ui.compare.AbstractContentViewer;
import org.eclipse.xtext.ui.compare.StreamContentDocumentProvider;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;

public class DefaultContentViewer
extends AbstractContentViewer {
    @Inject
    protected XtextSourceViewerConfiguration sourceViewerConfiguration;
    @Inject
    protected StreamContentDocumentProvider documentProvider;

    protected ISourceViewer createSourceViewer() {
        return new SourceViewer(this.getParent(), null, 0x2000300);
    }

    protected void configureSourceViewer(ISourceViewer sourceViewer) {
        sourceViewer.setEditable(false);
        sourceViewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        if (sourceViewer instanceof ITextViewerExtension6) {
            ITextViewerExtension6 textViewerExtension6 = (ITextViewerExtension6)sourceViewer;
            textViewerExtension6.setHyperlinkDetectors(null, this.sourceViewerConfiguration.getHyperlinkStateMask(sourceViewer));
        }
        if (sourceViewer instanceof ITextViewerExtension2) {
            String[] configuredContentTypes;
            ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2)sourceViewer;
            String[] stringArray = configuredContentTypes = this.sourceViewerConfiguration.getConfiguredContentTypes(sourceViewer);
            int n = configuredContentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                textViewerExtension2.removeTextHovers(contentType);
                ++n2;
            }
        }
    }

    public void setInput(Object input) {
        this.documentProvider.disconnect(this.getInput());
        super.setInput(input);
        if (input != null) {
            try {
                this.documentProvider.connect(input);
                this.sourceViewer.setDocument(this.documentProvider.getDocument(input));
            }
            catch (CoreException coreException) {
                throw new WrappedException((Exception)((Object)coreException));
            }
        }
    }
}

