/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hyperlinking;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkLabelProvider;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkHelper
implements IHyperlinkHelper {
    @Inject
    @HyperlinkLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    protected Provider<XtextHyperlink> getHyperlinkProvider() {
        return this.hyperlinkProvider;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        ArrayList links = Lists.newArrayList();
        HyperlinkAcceptor acceptor = new HyperlinkAcceptor(links);
        this.createHyperlinksByOffset(resource, offset, acceptor);
        if (!links.isEmpty()) {
            return (IHyperlink[])Iterables.toArray((Iterable)links, IHyperlink.class);
        }
        return null;
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObject crossLinkedEObject = this.eObjectAtOffsetHelper.resolveCrossReferencedElementAt(resource, offset);
        if (crossLinkedEObject != null && !crossLinkedEObject.eIsProxy()) {
            INode crossRefNode;
            ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
            if (leafNode.isHidden() && leafNode.getOffset() == offset) {
                leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)(offset - 1));
            }
            if ((crossRefNode = this.getParentNodeWithCrossReference((INode)leafNode)) != null) {
                Region region = new Region(crossRefNode.getOffset(), crossRefNode.getLength());
                this.createHyperlinksTo(resource, region, crossLinkedEObject, acceptor);
            }
        }
    }

    protected INode getParentNodeWithCrossReference(INode startNode) {
        if (startNode == null) {
            return null;
        }
        if (startNode.getGrammarElement() instanceof CrossReference) {
            return startNode;
        }
        return this.getParentNodeWithCrossReference((INode)startNode.getParent());
    }

    public void createHyperlinksTo(XtextResource from, Region region, EObject to, IHyperlinkAcceptor acceptor) {
        URIConverter uriConverter = from.getResourceSet().getURIConverter();
        String hyperlinkText = this.labelProvider.getText((Object)to);
        URI uri = EcoreUtil.getURI((EObject)to);
        URI normalized = uriConverter.normalize(uri);
        XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
        result.setHyperlinkRegion(region);
        result.setURI(normalized);
        result.setHyperlinkText(hyperlinkText);
        acceptor.accept(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final List<IHyperlink> links;

        public HyperlinkAcceptor(List<IHyperlink> links) {
            this.links = links;
        }

        @Override
        public void accept(IHyperlink hyperlink) {
            if (hyperlink != null) {
                this.links.add(hyperlink);
            }
        }
    }
}

