/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.ILinkedPositionGroupCalculator;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkedPositionGroupCalculator
implements ILinkedPositionGroupCalculator {
    private static final Logger LOG = Logger.getLogger(AbstractLinkedPositionGroupCalculator.class);

    protected LinkedPositionGroup createLinkedGroupFromReplaceEdits(List<ReplaceEdit> edits, XtextEditor xtextEditor, final String originalName, SubMonitor progress) {
        if (edits == null) {
            return null;
        }
        final IXtextDocument document = xtextEditor.getDocument();
        LinkedPositionGroup group = new LinkedPositionGroup();
        Iterable linkedPositions = Iterables.filter((Iterable)Iterables.transform(edits, (Function)new Function<ReplaceEdit, LinkedPosition>(){

            public LinkedPosition apply(ReplaceEdit edit) {
                try {
                    String textToReplace = document.get(edit.getOffset(), edit.getLength());
                    int indexOf = textToReplace.indexOf(originalName);
                    if (indexOf != -1) {
                        int calculatedOffset = edit.getOffset() + indexOf;
                        return new LinkedPosition((IDocument)document, calculatedOffset, originalName.length());
                    }
                }
                catch (BadLocationException exc) {
                    LOG.error((Object)("Skipping invalid text edit " + Strings.notNull((Object)edit)), (Throwable)exc);
                }
                return null;
            }
        }), (Predicate)Predicates.notNull());
        progress.worked(10);
        int invocationOffset = xtextEditor.getInternalSourceViewer().getSelectedRange().x;
        int i = 0;
        for (LinkedPosition position : this.sortPositions(linkedPositions, invocationOffset)) {
            try {
                position.setSequenceNumber(i);
                ++i;
                group.addPosition(position);
            }
            catch (BadLocationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return group;
    }

    protected Iterable<LinkedPosition> sortPositions(Iterable<LinkedPosition> linkedPositions, final int invocationOffset) {
        Comparator<LinkedPosition> comparator = new Comparator<LinkedPosition>(){

            @Override
            public int compare(LinkedPosition left, LinkedPosition right) {
                return this.rank(left) - this.rank(right);
            }

            private int rank(LinkedPosition o1) {
                int relativeRank = o1.getOffset() + o1.length - invocationOffset;
                if (relativeRank < 0) {
                    return Integer.MAX_VALUE + relativeRank;
                }
                return relativeRank;
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, linkedPositions);
    }
}

