/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.google.inject.internal.Join;
import com.google.inject.internal.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.util.formallang.IPdaAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdaUtil {
    public final long UNREACHABLE = Long.MAX_VALUE;

    public <STATE, STACKITEM> boolean canReach(IPdaAdapter<STATE, STACKITEM> pda, STATE state, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        return this.distanceTo(pda, Collections.singleton(state), stack, matches, canPass) != Long.MAX_VALUE;
    }

    protected <T> StackItem<T> createStack(Iterator<T> stack) {
        if (stack.hasNext()) {
            return new StackItem<T>(stack, stack.next());
        }
        return new StackItem<Object>(null, null);
    }

    public <STATE, STACKITEM> long distanceTo(IPdaAdapter<STATE, STACKITEM> pda, Iterable<STATE> starts, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        TraceItem<STATE, STACKITEM> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.size();
        }
        return Long.MAX_VALUE;
    }

    public <STATE, STACKITEM> List<STATE> shortestPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterable<STATE> starts, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        TraceItem<STATE, STACKITEM> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <STATE, STACKITEM> List<STATE> shortestPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack, Predicate<STATE> matches) {
        return this.shortestPathTo(pda, pda.getStartStates(), stack, matches, Predicates.alwaysTrue());
    }

    public <STATE, STACKITEM> List<STATE> shortestPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        return this.shortestPathTo(pda, pda.getStartStates(), stack, matches, canPass);
    }

    public <STATE, STACKITEM> List<STATE> shortestPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack, STATE match) {
        return this.shortestPathTo(pda, pda.getStartStates(), stack, Predicates.equalTo(match), Predicates.alwaysTrue());
    }

    public <STATE, STACKITEM> List<STATE> shortestPathToFinalState(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack) {
        final HashSet ends = Sets.newHashSet(pda.getFinalStates());
        if (ends.isEmpty()) {
            if (pda.getStartStates().iterator().hasNext()) {
                return null;
            }
            return Collections.emptyList();
        }
        return this.shortestPathTo(pda, pda.getStartStates(), stack, new Predicate<STATE>(){

            public boolean apply(STATE input) {
                return ends.contains(input);
            }
        }, Predicates.alwaysTrue());
    }

    public <STATE, STACKITEM> List<STATE> shortestStackpruningPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterable<STATE> starts, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        TraceItem<STATE, STACKITEM> trace = this.traceToWithPruningStack(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <STATE, STACKITEM> List<STATE> shortestStackpruningPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack, Predicate<STATE> matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStartStates(), stack, matches, Predicates.alwaysTrue());
    }

    public <STATE, STACKITEM> List<STATE> shortestStackpruningPathTo(IPdaAdapter<STATE, STACKITEM> pda, Iterator<STACKITEM> stack, STATE matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStartStates(), stack, Predicates.equalTo(matches), Predicates.alwaysTrue());
    }

    protected <STATE, STACKITEM> TraceItem<STATE, STACKITEM> trace(IPdaAdapter<STATE, STACKITEM> pda, Iterable<STATE> starts, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        StackItem<STACKITEM> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        for (STATE start : starts) {
            current.add(new TraceItem<STATE, STACKITEM>(null, start, stackItem));
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        return new TraceItem(trace, follower, trace.stackitem);
                    }
                    if (!canPass.apply(follower)) continue;
                    STACKITEM push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    STACKITEM pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return null;
    }

    protected <STATE, STACKITEM> TraceItem<STATE, STACKITEM> traceToWithPruningStack(IPdaAdapter<STATE, STACKITEM> pda, Iterable<STATE> starts, Iterator<STACKITEM> stack, Predicate<STATE> matches, Predicate<STATE> canPass) {
        StackItem<STACKITEM> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        TraceItem result = null;
        for (STATE start : starts) {
            TraceItem<STATE, STACKITEM> item = new TraceItem<STATE, STACKITEM>(null, start, stackItem);
            current.add(item);
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        TraceItem found = new TraceItem(trace, follower, trace.stackitem);
                        if (found.stackitem == null) {
                            return found;
                        }
                        if (result == null || result.stackitem.size() > found.stackitem.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        } else if (result.stackitem.size() == found.stackitem.size() && result.size() > found.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        }
                    }
                    if (!canPass.apply(follower)) continue;
                    STACKITEM push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    STACKITEM pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StackItem<T> {
        protected StackItem<T> parent;
        protected Iterator<T> parentIt;
        protected T value;

        public StackItem(Iterator<T> parentIt, T value) {
            this.parentIt = parentIt;
            this.value = value;
        }

        public StackItem(StackItem<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        public T peek() {
            return this.value;
        }

        public StackItem<T> pop() {
            if (this.parent != null) {
                return this.parent;
            }
            if (this.parentIt != null && this.parentIt.hasNext()) {
                this.parent = new StackItem<T>(this.parentIt, this.parentIt.next());
                return this.parent;
            }
            return null;
        }

        public StackItem<T> push(T value) {
            return new StackItem<T>(this, value);
        }

        public int size() {
            int result = 0;
            StackItem<T> current = this;
            while (current != null) {
                ++result;
                current = current.pop();
            }
            return result;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            StackItem<T> current = this;
            while (current != null) {
                if (current.value != null) {
                    result.add(current.value.toString());
                }
                current = current.pop();
            }
            return Join.join((String)", ", (Iterable)result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TraceItem<STATE, STACKITEM> {
        protected TraceItem<STATE, STACKITEM> parent;
        protected StackItem<STACKITEM> stackitem;
        protected STATE state;

        public TraceItem(TraceItem<STATE, STACKITEM> parent, STATE state, StackItem<STACKITEM> stackitem) {
            this.parent = parent;
            this.state = state;
            this.stackitem = stackitem;
        }

        public List<STATE> asList() {
            ArrayList result = Lists.newArrayList();
            TraceItem<STATE, STACKITEM> current = this;
            while (current != null) {
                result.add(current.state);
                current = current.parent;
            }
            Collections.reverse(result);
            return result;
        }

        public int size() {
            int result = 0;
            TraceItem<STATE, STACKITEM> current = this;
            while (current != null) {
                ++result;
                current = current.parent;
            }
            return result;
        }

        public String toString() {
            return "States: " + this.asList() + " Stack: " + this.stackitem;
        }
    }
}

