/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting.INodeModelStreamer;
import org.eclipse.xtext.formatting.impl.AbstractNodeModelFormatter;
import org.eclipse.xtext.formatting.impl.AbstractTokenStream;
import org.eclipse.xtext.formatting.impl.BaseTokenStream;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;
import org.eclipse.xtext.util.ITextRegion;

public class DefaultNodeModelFormatter
extends AbstractNodeModelFormatter {
    @Inject
    protected IFormatter formatter;
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    protected INodeModelStreamer nodeModelStreamer;

    public INodeModelFormatter.IFormattedRegion format(ICompositeNode root, int offset, int length) {
        String indent = this.getIndentation(root, offset);
        TokenStringBuffer buf = new TokenStringBuffer();
        AbstractTokenStream out = offset == 0 ? buf : new FilterFirstWhitespaceStream(buf);
        ITokenStream fmt = this.formatter.createFormatterStream(indent, out, false);
        try {
            ITextRegion range = this.nodeModelStreamer.feedTokenStream(fmt, root, offset, length);
            return new AbstractNodeModelFormatter.FormattedRegion(range.getOffset(), range.getLength(), buf.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIndentation(ICompositeNode root, int fromOffset) {
        if (fromOffset == 0) {
            return "";
        }
        ArrayList<ILeafNode> r = new ArrayList<ILeafNode>();
        for (ILeafNode l : root.getLeafNodes()) {
            if (l.getOffset() >= fromOffset) break;
            r.add(l);
        }
        Pattern p = Pattern.compile("\\n([ \\t]*)");
        int i = r.size() - 1;
        while (i >= 0) {
            Matcher m = p.matcher(((ILeafNode)r.get(i)).getText());
            if (m.find()) {
                String ind = m.group(1);
                while (m.find()) {
                    ind = m.group(1);
                }
                return ind;
            }
            --i;
        }
        return "";
    }

    protected class FilterFirstWhitespaceStream
    extends BaseTokenStream {
        boolean firstPassed;

        protected FilterFirstWhitespaceStream(ITokenStream out) {
            super(out);
            this.firstPassed = false;
        }

        public void writeHidden(EObject grammarElement, String value) throws IOException {
            if (this.firstPassed) {
                this.out.writeHidden(grammarElement, value);
            } else {
                boolean isWhitespace;
                boolean bl = isWhitespace = grammarElement instanceof AbstractRule && DefaultNodeModelFormatter.this.hiddenTokenHelper.isWhitespace((AbstractRule)grammarElement);
                if (!isWhitespace) {
                    this.out.writeHidden(grammarElement, value);
                    this.firstPassed = true;
                }
            }
        }

        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            this.firstPassed = true;
            this.out.writeSemantic(grammarElement, value);
        }
    }
}

