/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.ModelMigrationDialog;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmaltheaModelMigrationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmaltheaModelMigrationHandler.class);
    private static final String MODEL_MIGRATION = "AMALTHEA Model Migration";
    private static final String SIMPLE_MIGRATION = "simplemigration";

    @Execute
    public void execute(Shell shell, @Service MigrationProcessor migrationProcessor, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ISelection selection, @Optional @Named(value="executioncontext") @Named(value="executioncontext") String executionContext, @Optional @Named(value="APP4MC_MODEL_VERSION") @Named(value="APP4MC_MODEL_VERSION") String modelEditorVersion) {
        if (selection instanceof TreeSelection) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (MigrationSettings migrationSettings = new MigrationSettings();){
                ArrayList<File> inputModels = new ArrayList<File>();
                IProject iProject = this.getProjectFromSelection((TreeSelection)selection, shell);
                if (iProject == null) {
                    return;
                }
                String path = iProject.getLocation().toOSString();
                File file = new File(path);
                migrationSettings.setProject(file);
                IContainer selectedContainer = this.collectInput((TreeSelection)selection, inputModels);
                if (modelEditorVersion != null) {
                    migrationSettings.setMigrationModelVersion(modelEditorVersion);
                }
                try {
                    List modelFiles = MigrationHelper.populateModels(inputModels, (MigrationSettings)migrationSettings);
                    migrationSettings.getMigModelFiles().addAll(modelFiles);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load model files", (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)("Failed to load model files: " + e.getLocalizedMessage()));
                    if (migrationSettings != null) {
                        migrationSettings.close();
                    }
                    return;
                }
                if (this.isSimpleMigration(executionContext) && migrationSettings.getMigModelFiles().size() == 1) {
                    MigrationInputFile migrationInputFile = (MigrationInputFile)migrationSettings.getMigModelFiles().get(0);
                    migrationSettings.setOutputDirectoryLocation(migrationInputFile.getOriginalFile().getParent());
                    migrationSettings.setCreateBackupFile(true);
                    ModelMigrationJob migrationJob = new ModelMigrationJob(MODEL_MIGRATION, migrationProcessor, migrationSettings, iProject);
                    migrationJob.setUser(true);
                    migrationJob.schedule();
                } else {
                    ModelMigrationDialog dialog = new ModelMigrationDialog(shell, migrationProcessor, migrationSettings, iProject);
                    dialog.setSelectedContainer(selectedContainer);
                    dialog.open();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private IProject getProjectFromSelection(TreeSelection selection, Shell shell) {
        TreePath[] paths = selection.getPaths();
        String projectSegment = null;
        IProject iProject = null;
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object firstSegment = treePath.getFirstSegment();
            if (projectSegment == null) {
                projectSegment = firstSegment.toString();
                iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                if (iProject == null) {
                    firstSegment = treePath.getSegment(1);
                    projectSegment = firstSegment.toString();
                    iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                }
            } else if (!projectSegment.equals(firstSegment.toString())) {
                MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)"Migration across multiple projects is not supported.");
            }
            ++n2;
        }
        return iProject;
    }

    private IContainer collectInput(TreeSelection selection, List<File> inputModels) {
        TreePath[] paths = selection.getPaths();
        IContainer selectedContainer = null;
        HashSet<File> inputFiles = new HashSet<File>();
        HashSet<File> parents = new HashSet<File>();
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof IAdaptable) {
                IFile iFile = (IFile)((IAdaptable)lastSegment).getAdapter(IFile.class);
                if (iFile != null) {
                    String path2 = iFile.getRawLocation().toOSString();
                    File file2 = new File(path2);
                    try {
                        inputFiles.add(file2.getCanonicalFile());
                        parents.add(file2.getParentFile());
                    }
                    catch (IOException e) {
                        LOGGER.error("Error fetching the file : {}", (Object)iFile, (Object)e);
                    }
                } else {
                    IContainer container = (IContainer)((IAdaptable)lastSegment).getAdapter(IContainer.class);
                    if (container != null) {
                        selectedContainer = container;
                        Path modelFilePath = Paths.get(container.getLocationURI());
                        try {
                            Throwable e = null;
                            Object var16_21 = null;
                            try (Stream<Path> directoryStream = Files.walk(modelFilePath, 1, new FileVisitOption[0]);){
                                inputFiles.addAll(directoryStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> MigrationHelper.isModelFile((String)file.toString())).map(Path::toFile).collect(Collectors.toList()));
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                throw e;
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to collect model files in container", (Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
        for (File parent : parents) {
            File[] allFilesInDirectory = parent.listFiles((dir, name) -> MigrationHelper.isModelFile((String)name));
            inputFiles.addAll(Arrays.asList(allFilesInDirectory));
        }
        inputModels.addAll(inputFiles);
        return selectedContainer;
    }

    private boolean isSimpleMigration(String context) {
        return context != null && context.equals(SIMPLE_MIGRATION);
    }
}

