/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.xpath.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.xpath.utils.XpathFragment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkXpathOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkXpathOperation.class);

    public Map<String, List<Element>> invokeXpath(Document document, Collection<String> xpaths) {
        HashMap<String, List<Element>> resultsMap = new HashMap<String, List<Element>>();
        try {
            HashMap<String, XpathFragment> fragmentsMap = new HashMap<String, XpathFragment>();
            for (String xpath : xpaths) {
                StringBuilder fragmentStringBuffer = new StringBuilder();
                char[] charArray = xpath.toCharArray();
                int length = charArray.length;
                XpathFragment parentFragmentObject = null;
                int i = 0;
                while (i < length) {
                    char _char = charArray[i];
                    if (_char == '/') {
                        if (i + 1 < length) {
                            char _char_next = charArray[i + 1];
                            if (_char_next == '/') {
                                fragmentStringBuffer.append(_char);
                                fragmentStringBuffer.append(_char_next);
                                ++i;
                            } else {
                                String fragmentString = fragmentStringBuffer.toString();
                                if (fragmentString.length() > 0) {
                                    String xpathSubContent_from_begining_till_current_index = xpath.substring(0, i);
                                    if (fragmentsMap.containsKey(xpathSubContent_from_begining_till_current_index)) {
                                        parentFragmentObject = (XpathFragment)fragmentsMap.get(xpathSubContent_from_begining_till_current_index);
                                    } else {
                                        XpathFragment fragmentObject = new XpathFragment();
                                        fragmentObject.setValue(fragmentString);
                                        fragmentObject.setParent(parentFragmentObject);
                                        fragmentsMap.put(xpathSubContent_from_begining_till_current_index, fragmentObject);
                                        parentFragmentObject = fragmentObject;
                                    }
                                }
                                fragmentStringBuffer.setLength(0);
                                fragmentStringBuffer.append("./");
                            }
                        }
                    } else {
                        fragmentStringBuffer.append(_char);
                    }
                    ++i;
                }
                String fragmentString = fragmentStringBuffer.toString();
                if (fragmentString.length() <= 0) continue;
                XpathFragment fragment = new XpathFragment();
                fragment.setValue(fragmentString);
                fragment.setParent(parentFragmentObject);
                fragmentsMap.put(xpath, fragment);
            }
            Set keySet = fragmentsMap.keySet();
            for (String string : keySet) {
                LOGGER.trace("Xpath Fragment : {} associated Xpath chunk : {}", (Object)string, (Object)((XpathFragment)fragmentsMap.get(string)).getValue());
            }
            Element rootElement = document.getRootElement();
            for (String xpath : xpaths) {
                XpathFragment xpathFragment;
                if (resultsMap.containsKey(xpath) || (xpathFragment = (XpathFragment)fragmentsMap.get(xpath)) == null) continue;
                xpathFragment.visit(rootElement);
                List<Element> xmlElements = xpathFragment.getXmlElements();
                resultsMap.put(xpath, xmlElements);
                LOGGER.trace("xpath : {} elements : {}", (Object)xpath, (Object)xmlElements.size());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return resultsMap;
    }
}

