/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.util.sessionlog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Predicate;

public class SessionLogEntry
implements Predicate<Status> {
    public final Status status;
    public final String message;
    public final Throwable throwable;

    public SessionLogEntry(Status status, String message) {
        this(status, message, null);
    }

    public SessionLogEntry(Status status, String message, Throwable throwable) {
        this.status = status;
        this.message = message;
        this.throwable = throwable;
    }

    public String getStackTrace() {
        if (this.throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.throwable.printStackTrace(pw);
            return sw.toString();
        }
        return "";
    }

    @Override
    public boolean test(Status t) {
        switch (t) {
            case ERROR: {
                return this.status == Status.ERROR;
            }
            case WARNING: {
                return this.status == Status.ERROR || this.status == Status.WARNING;
            }
            case INFO: {
                return this.status == Status.ERROR || this.status == Status.WARNING || this.status == Status.INFO;
            }
            case DEBUG: {
                return true;
            }
        }
        return true;
    }

    public static enum Status {
        DEBUG,
        INFO,
        WARNING,
        ERROR;


        public static Status parseStatus(String logLevel) {
            Status logStatus = DEBUG;
            if (logLevel != null) {
                try {
                    logStatus = Status.valueOf(logLevel);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return logStatus;
        }
    }
}

