/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters210.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=2.0.0", "output_model_version=2.1.0"}, service={IConverter.class})
public class ConditionConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        this.logger.info("Migration from {0} to {1} : Executing Condition converter for model file : {2}", new Object[]{this.getInputModelVersion(), this.getOutputModelVersion(), targetFile.getName()});
        this.basicConvert(targetFile, fileDocumentMapping);
    }

    private void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateChannelFillConditions(rootElement);
    }

    private void updateChannelFillConditions(Element rootElement) {
        Namespace am = AmaltheaNamespaceRegistry.getNamespace((String)this.getInputModelVersion(), (String)"am");
        Namespace xsi = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
        StringBuilder xpathBuilder = new StringBuilder();
        xpathBuilder.append("./swModel/runnables/executionCondition//entries");
        xpathBuilder.append("|");
        xpathBuilder.append("./stimuliModel/stimuli/executionCondition//entries");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/tasks/activityGraph/items//condition//entries");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/isrs/activityGraph/items//condition//entries");
        xpathBuilder.append("|");
        xpathBuilder.append("./swModel/runnables/activityGraph/items//condition//entries");
        List entries = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuilder.toString(), Element.class, (Namespace[])new Namespace[]{am, xsi});
        if (entries == null) {
            return;
        }
        for (Element entry : entries) {
            Attribute typeAttr = entry.getAttribute("type", xsi);
            if (!"am:ChannelFillCondition".equals(typeAttr.getValue())) continue;
            entry.setAttribute("relation", "GREATER_THAN_OR_EQUAL");
        }
    }
}

