/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EventModelFactory;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;
import org.eclipse.emf.common.util.EMap;

public class EMPeriodicSynthetic
implements IEventModel {
    private Time tOuterPeriod;
    private List<Time> lEntries;

    @Override
    public long etaPlus(Time dt) {
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        double fraction = Math.floor(dt.divide(this.tOuterPeriod));
        long iEtaOuter = (long)((double)this.lEntries.size() * fraction);
        Time rhs = this.tOuterPeriod.multiply(Math.floor(dt.divide(this.tOuterPeriod)));
        Time tRemainder = dt.subtract(rhs);
        long iEtaInner = 0L;
        if (tRemainder.getValue().compareTo(BigInteger.ZERO) == 0) {
            iEtaInner = 0L;
        } else {
            int n = 1;
            while (n <= this.lEntries.size()) {
                Time tDeltaDashMin = null;
                int j = 0;
                while (j < this.lEntries.size()) {
                    if (tDeltaDashMin == null) {
                        tDeltaDashMin = this.deltaDash(n, j);
                    } else {
                        Time a = tDeltaDashMin;
                        Time b = this.deltaDash(n, j);
                        tDeltaDashMin = EventModelFactory.min(a, b);
                    }
                    ++j;
                }
                if (tDeltaDashMin != null && tDeltaDashMin.compareTo(tRemainder) < 0 && (long)n > iEtaInner) {
                    iEtaInner = n;
                }
                ++n;
            }
        }
        return iEtaOuter + iEtaInner;
    }

    @Override
    public long etaMinus(Time dt) {
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        double fraction = Math.floor(dt.divide(this.tOuterPeriod));
        long iEtaOuter = (long)((double)this.lEntries.size() * fraction);
        Time rhs = this.tOuterPeriod.multiply(Math.floor(dt.divide(this.tOuterPeriod)));
        Time tRemainder = dt.subtract(rhs);
        long iEtaInner = 0L;
        if (tRemainder.compareTo(this.deltaPlus(2L)) < 0) {
            iEtaInner = 0L;
        } else {
            long n = 1L;
            while (n <= (long)this.lEntries.size()) {
                Time tDeltaDashMax = null;
                int j = 0;
                while (j < this.lEntries.size()) {
                    if (tDeltaDashMax == null) {
                        tDeltaDashMax = this.deltaDash(n, j);
                    } else {
                        Time a = tDeltaDashMax;
                        Time b = this.deltaDash(n, j);
                        tDeltaDashMax = EventModelFactory.max(a, b);
                    }
                    ++j;
                }
                if (tDeltaDashMax != null && tDeltaDashMax.compareTo(tRemainder) <= 0 && n > iEtaInner) {
                    iEtaInner = n - 1L;
                }
                ++n;
            }
        }
        return iEtaOuter + iEtaInner;
    }

    @Override
    public Time deltaPlus(long n) {
        if (n < 2L) {
            return null;
        }
        long fullPeriodCount = (n - 1L) / (long)this.lEntries.size();
        Time tFull = this.tOuterPeriod.multiply(fullPeriodCount);
        Time tPartial = null;
        int j = 0;
        while (j < this.lEntries.size()) {
            Time difference = this.deltaDash((n - 1L) % (long)this.lEntries.size() + 1L, j);
            if (tPartial == null || difference.compareTo(tPartial) > 0) {
                tPartial = difference;
            }
            ++j;
        }
        return tFull.add(tPartial);
    }

    @Override
    public Time deltaMinus(long n) {
        if (n < 2L) {
            return null;
        }
        long fullPeriodCount = (n - 1L) / (long)this.lEntries.size();
        Time tFull = this.tOuterPeriod.multiply(fullPeriodCount);
        Time tPartial = null;
        int j = 0;
        while (j < this.lEntries.size()) {
            Time difference = this.deltaDash((n - 1L) % (long)this.lEntries.size() + 1L, j);
            if (tPartial == null || difference.compareTo(tPartial) < 0) {
                tPartial = difference;
            }
            ++j;
        }
        return tFull.add(tPartial);
    }

    private Time deltaDash(long l, int j) {
        Time b;
        Time a = this.lEntries.get(j);
        if (j + this.k(l) >= this.lEntries.size()) {
            int index = j + this.k(l) - this.lEntries.size();
            b = this.lEntries.get(index);
            b = b.add(this.tOuterPeriod);
        } else {
            b = this.lEntries.get(j + this.k(l));
        }
        return b.subtract(a);
    }

    private int k(long l) {
        assert (l > 0L);
        int elementCount = this.lEntries.size();
        return (int)(l - 1L - (l - 1L) / (long)elementCount * (long)elementCount);
    }

    @Override
    public double getUtilization(Process process, RuntimeUtil.TimeType tt, EMap<ModeLabel, String> modes) {
        Time executionTime = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        return executionTime.multiply(this.getEntries().size()).divide(this.getOuterPeriod());
    }

    public Time getOuterPeriod() {
        return this.tOuterPeriod;
    }

    public void setOuterPeriod(Time tOuterPeriod) {
        this.tOuterPeriod = tOuterPeriod;
    }

    public List<Time> getEntries() {
        return this.lEntries;
    }

    public void setEntries(List<Time> lEntries) {
        this.lEntries = lEntries;
    }
}

