/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.hardware;

import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryDefinition;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-HW-AccessPath", checks={"HwAccessPath ranges and memory size must be consistent", "HwAccessPath elements must be consistent"})
public class AmHwAccessPath
extends AmaltheaValidation {
    private static final String HW_ACCESS_PATH = "HW Access Path ";

    public EClassifier getEClassifier() {
        return ePackage.getHwAccessPath();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof HwAccessPath) {
            void path;
            HwAccessPath hwAccessPath = (HwAccessPath)eObject;
            HwAccessPath cfr_ignored_0 = (HwAccessPath)eObject;
            this.validateAccessPathRangeAndMemorySize((HwAccessPath)path, results);
            this.validateAccessPathElements((HwAccessPath)path, results);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateAccessPathRangeAndMemorySize(HwAccessPath path, List<ValidationDiagnostic> results) {
        HwDestination hwDestination;
        boolean performRangeCheck = true;
        MemoryDefinition memoryDef = null;
        long addressRange = path.getEndAddress() - path.getStartAddress();
        long requiredSize = path.getMemOffset() + addressRange;
        if (addressRange < 0L) {
            this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_EndAddress(), HW_ACCESS_PATH + this.name((INamed)path) + ": Start address > End address");
            performRangeCheck = false;
        }
        if ((hwDestination = path.getDestination()) instanceof Memory) {
            void memory;
            Memory memory2 = (Memory)hwDestination;
            Memory cfr_ignored_0 = (Memory)hwDestination;
            memoryDef = memory.getDefinition();
            if (memoryDef == null) {
                this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwPath_Destination(), HW_ACCESS_PATH + this.name((INamed)path) + ": Destination (Memory) size is undefined");
            }
        }
        if (performRangeCheck && memoryDef != null && requiredSize > memoryDef.getSize().getNumberBytes()) {
            this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_EndAddress(), HW_ACCESS_PATH + this.name((INamed)path) + ": Address range > Memory size");
        }
    }

    private void validateAccessPathElements(HwAccessPath path, List<ValidationDiagnostic> results) {
        EList pathElements = path.getPathElements();
        if (pathElements.isEmpty()) {
            return;
        }
        ProcessingUnit source = path.getSource();
        HwDestination destination = path.getDestination();
        HwPathElement first = (HwPathElement)pathElements.get(0);
        HwPathElement last = (HwPathElement)pathElements.get(pathElements.size() - 1);
        if (first instanceof HwConnection) {
            if (Collections.disjoint(source.getPorts(), first.getPorts())) {
                this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_PathElements(), HW_ACCESS_PATH + this.name((INamed)path) + ": No common port at the beginning of the path");
            }
        } else {
            this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_PathElements(), HW_ACCESS_PATH + this.name((INamed)path) + ": First path element must be a connection");
        }
        if (last instanceof HwConnection) {
            if (destination == null) {
                this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwPath_Destination(), HW_ACCESS_PATH + this.name((INamed)path) + ": Destination is undefined");
            } else if (Collections.disjoint(destination.getPorts(), last.getPorts())) {
                this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_PathElements(), HW_ACCESS_PATH + this.name((INamed)path) + ": No common port at the end of the path");
            }
        } else {
            this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_PathElements(), HW_ACCESS_PATH + this.name((INamed)path) + ": Last path element must be a connection");
        }
        if (pathElements.size() < 2) {
            return;
        }
        int i = 0;
        while (i < pathElements.size() - 1) {
            HwPathElement item1 = (HwPathElement)pathElements.get(i);
            HwPathElement item2 = (HwPathElement)pathElements.get(i + 1);
            if (Collections.disjoint(item1.getPorts(), item2.getPorts())) {
                this.addIssue(results, (EObject)path, (EStructuralFeature)ePackage.getHwAccessPath_PathElements(), HW_ACCESS_PATH + this.name((INamed)path) + ": No common port between element[" + i + "] and element[" + (i + 1) + "]");
            }
            ++i;
        }
    }
}

