/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.EncryptionUtil;

public class MemberRecord
extends SimpleRecord {
    protected DesignElement element;
    protected Module module;
    protected StructureContext memberRef;
    protected Structure structure;
    protected Object newValue;
    protected Object oldValue;

    public MemberRecord(Module module, DesignElement obj, StructureContext ref, Object value) {
        this.element = obj;
        this.memberRef = ref;
        this.newValue = value;
        assert (module != null);
        assert (obj == ref.getElement());
        this.module = module;
        this.structure = this.memberRef.getStructure();
        this.oldValue = this.memberRef.getLocalValue(module);
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.memberRef.getPropDefn().getDisplayName()});
    }

    @Override
    protected void perform(boolean undo) {
        PropertyDefn prop = this.memberRef.getPropDefn();
        if (this.structure != null) {
            Object value = null;
            Object tmpOldValue = null;
            if (!undo) {
                value = this.newValue;
                tmpOldValue = this.oldValue;
            } else {
                value = this.oldValue;
                tmpOldValue = this.newValue;
            }
            StructureContext context = new StructureContext(this.structure, prop, null);
            if (tmpOldValue instanceof Structure) {
                context.remove((Structure)tmpOldValue);
            }
            if (value instanceof Structure) {
                context.add((Structure)value);
            } else if (this.structure instanceof PropertyBinding && value != null && "value".equals(prop.getName())) {
                EncryptionUtil.setEncryptionBindingValue(this.module, this.structure, prop, value);
            } else {
                this.structure.setProperty(prop, value);
            }
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new PropertyEvent(this.element, this.memberRef.getPropDefn().getName());
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>(super.getPostTasks());
        NotificationEvent ev = this.getEvent();
        retList.add(new NotificationRecordTask(this.element, ev));
        if (this.structure != null && this.structure.isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.structure;
            retList.add(new NotificationRecordTask(refValue, ev));
        }
        return retList;
    }
}

