/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.StyleComboProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class BorderWidthDescriptorProvider
extends StyleComboProvider {
    private static final String LABEL_WIDTH = Messages.getString((String)"BordersPage.Label.Width");
    private String[] nameChoices;
    private String[] displayChoices;

    @Override
    public String getDisplayName() {
        return LABEL_WIDTH;
    }

    @Override
    public Object load() {
        String value = this.getLocalStringValue("borderLeftWidth");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderRightWidth");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderTopWidth");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        value = this.getLocalStringValue("borderBottomWidth");
        if (!"".equals(value = this.convertNameToDisplayName(value))) {
            this.indexText = value;
            return value;
        }
        return this.indexText;
    }

    @Override
    public void save(Object value) throws SemanticException {
        this.indexText = value == null ? "" : value;
        String saveValue = this.convertDisplayNameToName(value);
        if (((Boolean)this.styleMap.get("borderTopStyle")).booleanValue()) {
            this.save("borderTopWidth", saveValue);
        } else {
            this.save("borderTopWidth", null);
        }
        if (((Boolean)this.styleMap.get("borderBottomStyle")).booleanValue()) {
            this.save("borderBottomWidth", saveValue);
        } else {
            this.save("borderBottomWidth", null);
        }
        if (((Boolean)this.styleMap.get("borderLeftStyle")).booleanValue()) {
            this.save("borderLeftWidth", saveValue);
        } else {
            this.save("borderLeftWidth", null);
        }
        if (((Boolean)this.styleMap.get("borderRightStyle")).booleanValue()) {
            this.save("borderRightWidth", saveValue);
        } else {
            this.save("borderRightWidth", null);
        }
    }

    private String convertNameToDisplayName(String name) {
        int index;
        if (this.nameChoices == null) {
            this.getItems();
        }
        if ((index = Arrays.asList(this.nameChoices).indexOf(name)) >= 0 && index < this.displayChoices.length) {
            return this.displayChoices[index];
        }
        return "";
    }

    private String convertDisplayNameToName(Object displayName) {
        if (displayName == null) {
            return null;
        }
        int index = Arrays.asList(this.getItems()).indexOf(displayName);
        if (index >= 0 && index < this.nameChoices.length) {
            return this.nameChoices[index];
        }
        return null;
    }

    private String[] getWidths(IChoiceSet choiceSet) {
        IChoice[] choices = choiceSet.getChoices();
        this.nameChoices = new String[choices.length + 10];
        this.displayChoices = new String[choices.length + 10];
        int i = 0;
        while (i < choices.length) {
            this.nameChoices[i] = choices[i].getName();
            this.displayChoices[i] = choices[i].getDisplayName();
            ++i;
        }
        i = choices.length;
        while (i < choices.length + 10) {
            this.nameChoices[i] = String.valueOf(i + 1 - choices.length) + DEUtil.getMetaDataDictionary().getChoiceSet("units").findChoice("px").getName();
            this.displayChoices[i] = String.valueOf(i + 1 - choices.length) + DEUtil.getMetaDataDictionary().getChoiceSet("units").findChoice("px").getName();
            ++i;
        }
        return this.nameChoices;
    }

    @Override
    public Object[] getItems() {
        if (this.nameChoices == null) {
            return this.getWidths(ChoiceSetFactory.getElementChoiceSet((String)"Style", (String)"borderTopWidth"));
        }
        return this.nameChoices;
    }

    @Override
    public Object[] getDisplayItems() {
        if (this.displayChoices == null) {
            this.getWidths(ChoiceSetFactory.getElementChoiceSet((String)"Style", (String)"borderTopWidth"));
        }
        return this.displayChoices;
    }

    @Override
    public void handleModifyEvent() {
        try {
            if (this.indexText != null) {
                this.save(this.indexText);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

