/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.script.JSMethodRunner;
import org.mozilla.javascript.Scriptable;

public class DataSourceJSEventHandler
implements IBaseDataSourceEventHandler {
    private IBaseDataSourceDesign design;
    private JSMethodRunner runner;
    private ScriptContext cx;

    public DataSourceJSEventHandler(ScriptContext cx, IBaseDataSourceDesign dataSourceDesign) {
        assert (dataSourceDesign != null);
        this.design = dataSourceDesign;
        this.cx = cx;
    }

    protected IBaseDataSourceDesign getBaseDesign() {
        return this.design;
    }

    protected JSMethodRunner getRunner(Scriptable scope) {
        if (this.runner == null) {
            String scopeName = "DataSource[" + this.design.getName() + "]";
            this.runner = new JSMethodRunner(this.cx, scope, scopeName);
        }
        return this.runner;
    }

    @Override
    public void handleBeforeOpen(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getBeforeOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("beforeOpen", script);
        }
    }

    @Override
    public void handleBeforeClose(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getBeforeCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("beforeClose", script);
        }
    }

    @Override
    public void handleAfterOpen(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getAfterOpenScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("afterOpen", script);
        }
    }

    @Override
    public void handleAfterClose(IDataSourceInstanceHandle dataSource) throws BirtException {
        String script = this.getBaseDesign().getAfterCloseScript();
        if (script != null && script.length() > 0) {
            this.getRunner(dataSource.getScriptScope()).runScript("afterClose", script);
        }
    }
}

