/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AbstractScalarParameter;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.interfaces.IAbstractScalarParameterModel;

public abstract class AbstractScalarParameterHandleImpl
extends ParameterHandle
implements IAbstractScalarParameterModel {
    public AbstractScalarParameterHandleImpl(Module module, DesignElement element) {
        super(module, element);
    }

    public void setIsRequired(boolean isRequired) throws SemanticException {
        this.setBooleanProperty("isRequired", isRequired);
    }

    public boolean isRequired() {
        return this.getBooleanProperty("isRequired");
    }

    public void setSortByColumn(String sortByColumn) throws SemanticException {
        this.setStringProperty("sortByColumn", sortByColumn);
    }

    public String getSortByColumn() {
        return this.getStringProperty("sortByColumn");
    }

    public void setSortDirection(String direction) throws SemanticException {
        this.setProperty("sortDirection", direction);
    }

    public String getSortDirection() {
        return this.getStringProperty("sortDirection");
    }

    public void setSortBy(String sortValue) throws SemanticException {
        this.setProperty("sortBy", sortValue);
    }

    public String getSortBy() {
        return this.getStringProperty("sortBy");
    }

    public String getValueType() {
        return this.getStringProperty("valueType");
    }

    public void setValueType(String type) throws SemanticException {
        this.setStringProperty("valueType", type);
    }

    public void setListlimit(int listLimit) throws SemanticException {
        this.setIntProperty("listLimit", listLimit);
    }

    public int getListlimit() {
        return this.getIntProperty("listLimit");
    }

    public String getValueExpr() {
        return this.getStringProperty("valueExpr");
    }

    public void setValueExpr(String valueExpr) throws SemanticException {
        this.setStringProperty("valueExpr", valueExpr);
    }

    public String getLabelExpr() {
        return this.getStringProperty("labelExpr");
    }

    public void setLabelExpr(String labelExpr) throws SemanticException {
        this.setStringProperty("labelExpr", labelExpr);
    }

    public void setDataSetName(String dataSetName) throws SemanticException {
        this.setStringProperty("dataSetName", dataSetName);
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSetName", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("dataSetName", valueToSet);
        }
    }

    public Iterator<?> choiceIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("selectionList");
        return propHandle.iterator();
    }

    public String getDataSetName() {
        return this.getStringProperty("dataSetName");
    }

    public DataSetHandle getDataSet() {
        DataSet dataSet = ((AbstractScalarParameter)this.getElement()).getDataSetElement(this.module);
        if (dataSet == null) {
            return null;
        }
        return (DataSetHandle)dataSet.getHandle(dataSet.getRoot());
    }

    public void setDefaultValueList(List<? extends Object> defaultValueList) throws SemanticException {
        this.setProperty("defaultValue", defaultValueList);
    }

    public List getDefaultValueList() {
        return this.getListProperty("defaultValue");
    }

    public String getDataType() {
        return this.getStringProperty("dataType");
    }

    public void setDataType(String type) throws SemanticException {
        this.setStringProperty("dataType", type);
    }

    public void setDistinct(boolean distinct) throws SemanticException {
        this.setBooleanProperty("distinct", distinct);
    }

    public boolean distinct() {
        return this.getBooleanProperty("distinct");
    }
}

