/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerXUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManager {
    private Workbook workbook;
    private FontManager fm;
    private List<StylePair> styles = new ArrayList<StylePair>();
    private StyleManagerUtils smu;
    private CSSEngine cssEngine;
    private Locale locale;
    static int[] COMPARE_CSS_PROPERTIES = new int[]{39, 40, 49, 27, 24, 58, 50, 47, 20, 9, 4, 21, 10, 5, 8, 22, 11, 7, 15, 26, 18, 14, 57, 43};

    public StyleManager(Workbook workbook, Logger log, StyleManagerUtils smu, CSSEngine cssEngine, Locale locale) {
        this.workbook = workbook;
        this.fm = new FontManager(cssEngine, workbook, smu);
        this.smu = smu;
        this.cssEngine = cssEngine;
        this.locale = locale;
    }

    public FontManager getFontManager() {
        return this.fm;
    }

    public CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    private boolean stylesEquivalent(BirtStyle style1, BirtStyle style2) {
        int i = 0;
        while (i < COMPARE_CSS_PROPERTIES.length) {
            CSSValue value2;
            int prop = COMPARE_CSS_PROPERTIES[i];
            CSSValue value1 = style1.getProperty(prop);
            if (!StyleManagerUtils.objectsEqual(value1, value2 = style2.getProperty(prop))) {
                return false;
            }
            ++i;
        }
        return StyleManagerUtils.objectsEqual(style1.getProperty(70), style2.getProperty(70)) && StyleManagerUtils.dataFormatsEquivalent((DataFormatValue)style1.getProperty(3), (DataFormatValue)style2.getProperty(3)) && FontManager.fontsEquivalent(style1, style2);
    }

    private CellStyle createStyle(BirtStyle birtStyle) {
        CellStyle poiStyle = this.workbook.createCellStyle();
        Font font = this.fm.getFont(birtStyle);
        if (font != null) {
            poiStyle.setFont(font);
        }
        HorizontalAlignment alignment = this.smu.poiAlignmentFromBirtAlignment(birtStyle.getString(39));
        poiStyle.setAlignment(alignment);
        this.smu.addBackgroundColourToStyle(this.workbook, poiStyle, birtStyle.getString(40));
        if (this.smu instanceof StyleManagerXUtils) {
            this.smu.applyBorderStyle(this.workbook, poiStyle, birtStyle);
        } else {
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.TOP, birtStyle.getProperty(24), birtStyle.getProperty(49), birtStyle.getProperty(27));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.LEFT, birtStyle.getProperty(47), birtStyle.getProperty(58), birtStyle.getProperty(50));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.RIGHT, birtStyle.getProperty(4), birtStyle.getProperty(20), birtStyle.getProperty(9));
            this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.BOTTOM, birtStyle.getProperty(5), birtStyle.getProperty(21), birtStyle.getProperty(10));
        }
        this.smu.applyNumberFormat(this.workbook, birtStyle, poiStyle, this.locale);
        if ("pre".equals(birtStyle.getString(57))) {
            poiStyle.setWrapText(true);
        }
        if ("top".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.TOP);
        } else if ("middle".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        } else if ("bottom".equals(birtStyle.getString(43))) {
            poiStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        }
        CSSValue rotation = birtStyle.getProperty(70);
        if (rotation instanceof FloatValue) {
            poiStyle.setRotation((short)((FloatValue)rotation).getFloatValue());
        }
        this.styles.add(new StylePair(birtStyle.clone(), poiStyle));
        return poiStyle;
    }

    public CellStyle getStyle(BirtStyle birtStyle) {
        for (StylePair stylePair : this.styles) {
            if (!this.stylesEquivalent(birtStyle, stylePair.birtStyle)) continue;
            return stylePair.poiStyle;
        }
        return this.createStyle(birtStyle);
    }

    private BirtStyle birtStyleFromCellStyle(CellStyle source) {
        for (StylePair stylePair : this.styles) {
            if (!source.equals(stylePair.poiStyle)) continue;
            return stylePair.birtStyle.clone();
        }
        return new BirtStyle(this.cssEngine);
    }

    public CellStyle getStyleWithBorders(CellStyle source, CSSValue borderStyleBottom, CSSValue borderWidthBottom, CSSValue borderColourBottom, CSSValue borderStyleLeft, CSSValue borderWidthLeft, CSSValue borderColourLeft, CSSValue borderStyleRight, CSSValue borderWidthRight, CSSValue borderColourRight, CSSValue borderStyleTop, CSSValue borderWidthTop, CSSValue borderColourTop, CSSValue borderStyleDiagonal, CSSValue borderWidthDiagonal, CSSValue borderColourDiagonal, CSSValue borderStyleAntidiagonal, CSSValue borderWidthAntidiagonal, CSSValue borderColourAntidiagonal) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        if (borderStyleBottom != null && borderWidthBottom != null && borderColourBottom != null) {
            birtStyle.setProperty(21, borderStyleBottom);
            birtStyle.setProperty(10, borderWidthBottom);
            birtStyle.setProperty(5, borderColourBottom);
        }
        if (borderStyleLeft != null && borderWidthLeft != null && borderColourLeft != null) {
            birtStyle.setProperty(58, borderStyleLeft);
            birtStyle.setProperty(50, borderWidthLeft);
            birtStyle.setProperty(47, borderColourLeft);
        }
        if (borderStyleRight != null && borderWidthRight != null && borderColourRight != null) {
            birtStyle.setProperty(20, borderStyleRight);
            birtStyle.setProperty(9, borderWidthRight);
            birtStyle.setProperty(4, borderColourRight);
        }
        if (borderStyleTop != null && borderWidthTop != null && borderColourTop != null) {
            birtStyle.setProperty(49, borderStyleTop);
            birtStyle.setProperty(27, borderWidthTop);
            birtStyle.setProperty(24, borderColourTop);
        }
        if (borderStyleDiagonal != null && borderWidthDiagonal != null && borderColourDiagonal != null) {
            birtStyle.setProperty(22, borderStyleDiagonal);
            birtStyle.setProperty(11, borderWidthDiagonal);
            birtStyle.setProperty(7, borderColourDiagonal);
        }
        if (borderStyleAntidiagonal != null && borderWidthAntidiagonal != null && borderColourAntidiagonal != null) {
            birtStyle.setProperty(26, borderStyleAntidiagonal);
            birtStyle.setProperty(18, borderWidthAntidiagonal);
            birtStyle.setProperty(14, borderColourAntidiagonal);
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    public CellStyle getStyleWithExtraStyle(CellStyle source, IStyle birtExtraStyle) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        int i = 0;
        while (i < 71) {
            CSSValue value = birtExtraStyle.getProperty(i);
            if (value != null) {
                birtStyle.setProperty(i, value);
            }
            ++i;
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    private class StylePair {
        public BirtStyle birtStyle;
        public CellStyle poiStyle;

        public StylePair(BirtStyle birtStyle, CellStyle poiStyle) {
            this.birtStyle = birtStyle;
            this.poiStyle = poiStyle;
        }
    }
}

