/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class PageLayoutPropertyDescriptorProvider
extends SimpleComboPropertyDescriptorProvider {
    private static IChoiceSet choiceSet;

    public PageLayoutPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public String getDisplayName() {
        return Messages.getString("PageLayoutPropertyDescriptorProvider.PageLayout");
    }

    public Object load() {
        String value = (String)super.load();
        if (value != null) {
            int index = Arrays.asList(this.getValues()).indexOf(value);
            if (index < 0) {
                return value;
            }
            return this.getItems()[index];
        }
        return value;
    }

    public void save(Object value) throws SemanticException {
        int index;
        if (value != null && (index = Arrays.asList(this.getItems()).indexOf(value)) >= 0) {
            value = this.getValues()[index];
        }
        super.save(value);
    }

    public void setInput(Object input) {
        this.input = input;
        GroupElementHandle multiSelectionHandle = DEUtil.getMultiSelectionHandle((List)DEUtil.getInputElements((Object)input));
        choiceSet = multiSelectionHandle.getPropertyHandle(this.getProperty()).getPropertyDefn().getAllowedChoices();
    }

    public String[] getItems() {
        IChoice[] choice = choiceSet.getChoices();
        String[] items = new String[choice.length];
        int i = 0;
        while (i < choice.length) {
            items[i] = choice[i].getDisplayName();
            ++i;
        }
        return items;
    }

    public String[] getValues() {
        IChoice[] choice = choiceSet.getChoices();
        String[] items = new String[choice.length];
        int i = 0;
        while (i < choice.length) {
            items[i] = choice[i].getName();
            ++i;
        }
        return items;
    }
}

