/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import org.eclipse.birt.chart.engine.i18n.Messages;

public class NameSet {
    private String prefix;
    private String suffix;
    private String[] nameArray;
    private String[] displayNameArray;

    public NameSet(String prefix, String suffix, String[] name) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.nameArray = name;
        this.initDisplayNameArray();
    }

    public NameSet join(NameSet ns) {
        String[] nss = ns.getNames();
        String[] newNames = new String[this.nameArray.length + nss.length];
        System.arraycopy(this.nameArray, 0, newNames, 0, this.nameArray.length);
        System.arraycopy(nss, 0, newNames, this.nameArray.length, nss.length);
        return new NameSet(this.prefix, this.suffix, newNames);
    }

    private void initDisplayNameArray() {
        if (this.nameArray != null) {
            this.displayNameArray = new String[this.nameArray.length];
            int i = 0;
            while (i < this.displayNameArray.length) {
                this.displayNameArray[i] = Messages.getString(this.prefix + this.nameArray[i] + this.suffix);
                ++i;
            }
        }
    }

    public String getNameByDisplayName(String displayName) {
        int i = 0;
        while (i < this.displayNameArray.length) {
            if (displayName != null && displayName.equals(this.displayNameArray[i])) {
                return this.nameArray[i];
            }
            ++i;
        }
        return null;
    }

    public String getDisplayNameByName(String name) {
        int i = 0;
        while (i < this.nameArray.length) {
            if (name != null && name.equals(this.nameArray[i])) {
                return this.displayNameArray[i];
            }
            ++i;
        }
        return null;
    }

    public String getDisplayNameByName(String name, String defaultValue) {
        int i = 0;
        while (i < this.nameArray.length) {
            if (name != null && name.equals(this.nameArray[i])) {
                return this.displayNameArray[i];
            }
            ++i;
        }
        return defaultValue;
    }

    public int getSafeNameIndex(String name) {
        int i = 0;
        while (i < this.nameArray.length) {
            if (name != null && name.equals(this.nameArray[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getNameIndex(String name) {
        int i = 0;
        while (i < this.nameArray.length) {
            if (name != null && name.equals(this.nameArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getDisplayNames() {
        return this.displayNameArray;
    }

    public String[] getNames() {
        return this.nameArray;
    }
}

