/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;

public abstract class BaseLogUtil {
    public static String toString(Object source) {
        if (source instanceof Collection) {
            return BaseLogUtil.toString_Collection(source);
        }
        if (source instanceof FilterDefinition) {
            return BaseLogUtil.toString_FilterDefinition(source);
        }
        if (source instanceof ConditionalExpression) {
            return BaseLogUtil.toString_ConditionalExpression(source);
        }
        if (source instanceof ScriptExpression) {
            return BaseLogUtil.toString_ScriptExpression(source);
        }
        if (source instanceof InputParameterBinding) {
            return BaseLogUtil.toString_InputParameterBinding(source);
        }
        if (source instanceof GroupDefinition) {
            return BaseLogUtil.toString_GroupDefinition(source);
        }
        if (source instanceof SortDefinition) {
            return BaseLogUtil.toString_SortDefinition(source);
        }
        if (source instanceof QueryDefinition) {
            return BaseLogUtil.toString_QueryDefinition(source);
        }
        if (source instanceof OdaDataSetDesign) {
            return BaseLogUtil.toString_OdaDataSetDesign(source);
        }
        if (source instanceof OdaDataSourceDesign) {
            return BaseLogUtil.toString_OdaDataSourceDesign(source);
        }
        if (source == null) {
            return "null";
        }
        return source.toString();
    }

    private static String toString_Collection(Object source) {
        StringBuilder stringBuffer = new StringBuilder();
        Iterator iterator = ((Collection)source).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(BaseLogUtil.toString(iterator.next()) + ", \r\n\t");
        }
        String str = stringBuffer.toString();
        if (str.endsWith("\t")) {
            str = str.substring(0, str.length() - 5);
        }
        return str;
    }

    private static String toString_FilterDefinition(Object source) {
        return "FilterDefinition(" + BaseLogUtil.toString(((FilterDefinition)source).getExpression()) + ")";
    }

    private static String toString_ConditionalExpression(Object source) {
        StringBuilder stringBuffer = new StringBuilder("ConditionalExpression(");
        ConditionalExpression conditionalExpression = (ConditionalExpression)source;
        stringBuffer.append("Operator : " + conditionalExpression.getOperator() + ", ");
        stringBuffer.append("Expression : " + BaseLogUtil.toString(conditionalExpression.getExpression()) + ", ");
        if (!BaseLogUtil.isEmpty(conditionalExpression.getOperand1())) {
            stringBuffer.append("Operand1 : " + BaseLogUtil.toString(conditionalExpression.getOperand1()) + ", ");
        }
        if (!BaseLogUtil.isEmpty(conditionalExpression.getOperand2())) {
            stringBuffer.append("Operand2 : " + BaseLogUtil.toString(conditionalExpression.getOperand2()) + ")");
        }
        return stringBuffer.toString();
    }

    private static String toString_ScriptExpression(Object source) {
        return "ScriptExpression(Text:" + ((ScriptExpression)source).getText() + ")";
    }

    private static String toString_InputParameterBinding(Object source) {
        InputParameterBinding inputParameterBinding = (InputParameterBinding)source;
        StringBuilder stringBuffer = new StringBuilder("InputParameterBinding(");
        if (!BaseLogUtil.isEmpty(inputParameterBinding.getName())) {
            stringBuffer.append("Name : " + inputParameterBinding.getName() + ", ");
        }
        stringBuffer.append("Position : " + inputParameterBinding.getPosition() + ", ");
        stringBuffer.append("Expression : " + BaseLogUtil.toString(inputParameterBinding.getExpr()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_SortDefinition(Object source) {
        SortDefinition sort = (SortDefinition)source;
        StringBuilder stringBuffer = new StringBuilder("SortDefinition(");
        if (!BaseLogUtil.isEmpty(sort.getColumn())) {
            stringBuffer.append("Column : " + sort.getColumn() + ", ");
        }
        if (!BaseLogUtil.isEmpty(sort.getExpression())) {
            stringBuffer.append("getExpression : " + String.valueOf(sort.getExpression()) + ", ");
        }
        stringBuffer.append("SortDirection : " + sort.getSortDirection() + ",");
        stringBuffer.append("SortStrength : " + sort.getSortStrength() + ",");
        stringBuffer.append("SortLocale : " + String.valueOf(sort.getSortLocale()) + ")");
        return stringBuffer.toString();
    }

    private static String toString_GroupDefinition(Object source) {
        GroupDefinition group = (GroupDefinition)source;
        StringBuilder stringBuffer = new StringBuilder("GroupDefinition(");
        if (!BaseLogUtil.isEmpty(group.getName())) {
            stringBuffer.append("Name : " + group.getName() + ", ");
        }
        if (!BaseLogUtil.isEmpty(group.getKeyColumn())) {
            stringBuffer.append("KeyColumn : " + group.getKeyColumn() + ", ");
        }
        if (!BaseLogUtil.isEmpty(group.getKeyExpression())) {
            stringBuffer.append("KeyExpression : " + group.getKeyExpression() + ", ");
        }
        stringBuffer.append("SortDirection : " + group.getSortDirection() + ", ");
        stringBuffer.append("Interval : " + group.getInterval() + ", ");
        stringBuffer.append("IntervalRange : " + group.getIntervalRange() + ", ");
        if (!BaseLogUtil.isEmpty(group.getIntervalStart())) {
            stringBuffer.append("IntervalStart : " + String.valueOf(group.getIntervalStart()) + ", ");
        }
        if (!BaseLogUtil.isEmpty(group.getSubqueries())) {
            stringBuffer.append("Subqueries : " + BaseLogUtil.toString(group.getSubqueries()) + ", ");
        }
        if (!BaseLogUtil.isEmpty(group.getSorts())) {
            stringBuffer.append("Sorts : " + BaseLogUtil.toString(group.getSorts()) + ", ");
        }
        if (!BaseLogUtil.isEmpty(group.getFilters())) {
            stringBuffer.append("Filters : " + BaseLogUtil.toString(group.getFilters()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_QueryDefinition(Object source) {
        QueryDefinition querySpec = (QueryDefinition)source;
        StringBuilder stringBuffer = new StringBuilder("QueryDefinition(");
        stringBuffer.append("DataSetName : " + querySpec.getDataSetName() + "\r\n");
        if (!BaseLogUtil.isEmpty(querySpec.getBindings())) {
            stringBuffer.append("ResultSetExpressions : " + BaseLogUtil.toString(querySpec.getBindings()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getParentQuery())) {
            stringBuffer.append("ParentQuery : " + BaseLogUtil.toString(querySpec.getParentQuery()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getSubqueries())) {
            stringBuffer.append("Subqueries : " + BaseLogUtil.toString(querySpec.getSubqueries()) + "\r\n");
        }
        stringBuffer.append("MaxRows : " + querySpec.getMaxRows() + "\r\n");
        if (!BaseLogUtil.isEmpty(querySpec.getColumnProjection())) {
            int i = 0;
            while (i < querySpec.getColumnProjection().length) {
                stringBuffer.append("ColumnProjection : " + querySpec.getColumnProjection()[i] + "   ");
                ++i;
            }
            stringBuffer.append("\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getGroups())) {
            stringBuffer.append("Groups : " + BaseLogUtil.toString(querySpec.getGroups()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getFilters())) {
            stringBuffer.append("Filters : " + BaseLogUtil.toString(querySpec.getFilters()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getSorts())) {
            stringBuffer.append("Sorts : " + BaseLogUtil.toString(querySpec.getSorts()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(querySpec.getInputParamBindings())) {
            stringBuffer.append("InputParamBindings : " + BaseLogUtil.toString(querySpec.getInputParamBindings()) + ")\r\n");
        }
        return stringBuffer.toString();
    }

    private static String toString_OdaDataSetDesign(Object source) {
        OdaDataSetDesign dataSet = (OdaDataSetDesign)source;
        StringBuilder stringBuffer = new StringBuilder("OdaDataSetDesign(");
        if (!BaseLogUtil.isEmpty(dataSet.getName())) {
            stringBuffer.append("Name : " + dataSet.getName() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getDataSourceName())) {
            stringBuffer.append("DataSourceName : " + dataSet.getDataSourceName() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getAfterCloseScript())) {
            stringBuffer.append("AfterCloseScript : " + dataSet.getAfterCloseScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getAfterOpenScript())) {
            stringBuffer.append("AfterOpenScript : " + dataSet.getAfterOpenScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getBeforeCloseScript())) {
            stringBuffer.append("BeforeCloseScript : " + dataSet.getBeforeCloseScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getBeforeOpenScript())) {
            stringBuffer.append("BeforeOpenScript : " + dataSet.getBeforeOpenScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getOnFetchScript())) {
            stringBuffer.append("OnFetchScript : " + dataSet.getOnFetchScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getComputedColumns())) {
            stringBuffer.append("ComputedColumns : " + BaseLogUtil.toString(dataSet.getComputedColumns()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getFilters())) {
            stringBuffer.append("Filters : " + BaseLogUtil.toString(dataSet.getFilters()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getParameters())) {
            stringBuffer.append("Parameters : " + BaseLogUtil.toString(dataSet.getParameters()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getInputParamBindings())) {
            stringBuffer.append("InputParamBindings : " + BaseLogUtil.toString(dataSet.getInputParamBindings()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getResultSetHints())) {
            stringBuffer.append("ResultSetHints : " + BaseLogUtil.toString(dataSet.getResultSetHints()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getExtensionID())) {
            stringBuffer.append("ExtensionID : " + dataSet.getExtensionID() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getPrimaryResultSetName())) {
            stringBuffer.append("PrimaryResultSetName : " + dataSet.getPrimaryResultSetName() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getQueryText())) {
            stringBuffer.append("QueryText : " + dataSet.getQueryText() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getPrivateProperties())) {
            stringBuffer.append("PrivateProperties : " + BaseLogUtil.toString(dataSet.getPrivateProperties()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSet.getPublicProperties())) {
            stringBuffer.append("PublicProperties : " + BaseLogUtil.toString(dataSet.getPublicProperties()) + "\r\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_OdaDataSourceDesign(Object source) {
        OdaDataSourceDesign dataSource = (OdaDataSourceDesign)source;
        StringBuilder stringBuffer = new StringBuilder("OdaDataSourceDesign(");
        if (!BaseLogUtil.isEmpty(dataSource.getName())) {
            stringBuffer.append("Name : " + dataSource.getName() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getAfterCloseScript())) {
            stringBuffer.append("AfterCloseScript : " + dataSource.getAfterCloseScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getAfterOpenScript())) {
            stringBuffer.append("AfterOpenScript : " + dataSource.getAfterOpenScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getBeforeCloseScript())) {
            stringBuffer.append("BeforeCloseScript : " + dataSource.getBeforeCloseScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getBeforeOpenScript())) {
            stringBuffer.append("BeforeOpenScript : " + dataSource.getBeforeOpenScript() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getExtensionID())) {
            stringBuffer.append("ExtensionID : " + dataSource.getExtensionID() + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getPrivateProperties())) {
            stringBuffer.append("PrivateProperties : " + String.valueOf(dataSource.getPrivateProperties()) + "\r\n");
        }
        if (!BaseLogUtil.isEmpty(dataSource.getPublicProperties())) {
            Map publicProperties = dataSource.getPublicProperties();
            Object logMsg = " PulicProperties : ";
            for (Map.Entry entry : publicProperties.entrySet()) {
                String propName = entry.getKey().toString();
                String lcPropName = propName.toLowerCase();
                String propVal = lcPropName.indexOf("password") >= 0 || lcPropName.indexOf("pwd") >= 0 ? "***" : entry.getValue().toString();
                logMsg = (String)logMsg + propName + "=" + propVal + ";";
            }
            stringBuffer.append((String)logMsg + "\r\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static boolean isEmpty(Object source) {
        return source == null || "".equals(BaseLogUtil.toString(source));
    }
}

