/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.WordRecognizerWrapper;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultHyphenationManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.text.LineBreakChunk;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.WordWidth;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class TextCompositor {
    private FontInfo fontInfo;
    private int runLevel;
    int offset = 0;
    private ChunkGenerator remainChunks;
    private IWordRecognizer remainWords;
    private Word remainWord;
    private Word wordVestige;
    private boolean hasLineBreak = false;
    private boolean isNewLine = true;
    private boolean blankText = false;
    private boolean insertFirstExceedWord = false;
    private static int LINE_BREAK_COLLAPSE_FREE = 0;
    private static int LINE_BREAK_COLLAPSE_STANDING_BY = 1;
    private static int LINE_BREAK_COLLAPSE_OCCUPIED = 2;
    private int lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
    private ITextContent textContent;
    private FontMappingManager fontManager;
    private LayoutContext context;
    private boolean textWrapping;
    protected TextStyle textStyle = null;

    public TextCompositor(ITextContent textContent, FontMappingManager fontManager, LayoutContext context) {
        this.textContent = textContent;
        this.fontManager = fontManager;
        this.context = context;
        IStyle style = textContent.getComputedStyle();
        this.textWrapping = context.getTextWrapping() && !PropertyUtil.isWhiteSpaceNoWrap(style.getProperty(57));
        this.remainChunks = new ChunkGenerator(fontManager, textContent, context.getBidiProcessing(), context.getFontSubstitution());
    }

    public TextCompositor(ITextContent textContent, FontMappingManager fontManager, LayoutContext context, boolean blankText) {
        this(textContent, fontManager, context);
        this.blankText = blankText;
    }

    public boolean hasNextArea() {
        if (!this.textWrapping && this.hasLineBreak) {
            return false;
        }
        return this.offset < this.textContent.getText().length();
    }

    public void setNewLineStatus(boolean status) {
        this.isNewLine = status;
        if (this.isNewLine && !this.textWrapping) {
            this.insertFirstExceedWord = true;
        }
    }

    public TextArea getNextArea(int maxLineWidth) {
        if (!this.hasNextArea()) {
            throw new RuntimeException("No more text.");
        }
        TextArea textArea = this.getNextTextArea(maxLineWidth);
        if (textArea != null) {
            this.offset += textArea.getTextLength();
        }
        if (this.lineBreakCollapse == LINE_BREAK_COLLAPSE_OCCUPIED) {
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            return null;
        }
        return textArea;
    }

    protected boolean isEmptyWordVestige(Word wordVestige) {
        String value = wordVestige.getValue();
        int i = 0;
        while (i < value.length()) {
            if (value.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private TextArea getNextTextArea(int maxLineWidth) {
        if (this.wordVestige != null) {
            if (this.isEmptyWordVestige(this.wordVestige)) {
                this.offset += this.wordVestige.getLength();
                this.wordVestige = null;
                return null;
            }
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.wordVestige);
            return textArea;
        }
        if (this.remainWord != null) {
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.remainWord);
            this.remainWord = null;
            return textArea;
        }
        if (this.remainWords == null || !this.remainWords.hasWord()) {
            Chunk chunk = this.remainChunks.getNext();
            if (chunk instanceof LineBreakChunk) {
                FontHandler handler = new FontHandler(this.fontManager, this.textContent, false);
                TextArea textArea = this.createTextArea(this.textContent, handler.getFontInfo(), true);
                textArea.setTextLength(chunk.getLength());
                this.hasLineBreak = true;
                if (this.lineBreakCollapse == LINE_BREAK_COLLAPSE_STANDING_BY) {
                    this.lineBreakCollapse = LINE_BREAK_COLLAPSE_OCCUPIED;
                }
                return textArea;
            }
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            this.fontInfo = chunk.getFontInfo();
            this.runLevel = chunk.getRunLevel();
            this.remainWords = new WordRecognizerWrapper(chunk.getText(), this.context.getLocale());
        }
        TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
        textArea.setMaxWidth(maxLineWidth);
        textArea.setWidth(0);
        this.addWordsIntoTextArea(textArea, this.remainWords);
        return textArea;
    }

    protected TextArea createTextArea(ITextContent textContent, FontInfo fontInfo, boolean blankLine) {
        if (this.textStyle == null || this.textStyle.getFontInfo() != fontInfo) {
            this.textStyle = TextAreaLayout.buildTextStyle(textContent, fontInfo);
            if (this.blankText) {
                this.textStyle.setHasHyperlink(false);
            }
        }
        TextArea area = new TextArea(this.textStyle);
        area.setOffset(this.offset);
        if (blankLine) {
            area.lineBreak = true;
            area.blankLine = true;
        } else {
            area.setOffset(0);
            area.setTextLength(textContent.getText().length());
        }
        return area;
    }

    protected TextArea createTextArea(ITextContent textContent, int offset, int runLevel, FontInfo fontInfo) {
        if (this.textStyle == null || this.textStyle.getFontInfo() != fontInfo) {
            this.textStyle = TextAreaLayout.buildTextStyle(textContent, fontInfo);
            if (this.blankText) {
                this.textStyle.setHasHyperlink(false);
                this.textStyle.setLineThrough(false);
                this.textStyle.setUnderLine(false);
            }
        }
        TextArea area = new TextArea(textContent.getText(), this.textStyle);
        if (!this.blankText) {
            area.setAction(textContent.getHyperlinkAction());
        }
        area.setOffset(offset);
        area.setRunLevel(runLevel);
        area.setVerticalAlign(textContent.getComputedStyle().getProperty(43));
        return area;
    }

    private void addWordsIntoTextArea(TextArea textArea, IWordRecognizer words) {
        while (words.hasWord()) {
            Word word = words.getNextWord();
            this.addWordIntoTextArea(textArea, word);
            if (!textArea.isLineBreak()) continue;
            return;
        }
    }

    private void addWordIntoTextArea(TextArea textArea, Word word) {
        int adjustWordSize;
        int textLength = word.getLength();
        WordWidth wordWidth = this.getWordWidth(this.fontInfo, word);
        int letterSpacing = this.textStyle.getLetterSpacing();
        int width = wordWidth.width + letterSpacing * textLength;
        if (wordWidth.softHyphenWidth > 0) {
            width = width - wordWidth.softHyphenWidth + letterSpacing;
        }
        if (textArea.hasSpace((adjustWordSize = this.fontInfo.getItalicAdjust() + width) + wordWidth.softHyphenWidth * letterSpacing)) {
            this.addWord(textArea, textLength, wordWidth);
            this.wordVestige = null;
            if (this.remainWords.hasWord()) {
                if (textArea.hasSpace(this.textStyle.getWordSpacing())) {
                    textArea.addWordSpacing(this.textStyle.getWordSpacing());
                } else {
                    textArea.setLineBreak(true);
                    this.hasLineBreak = true;
                    this.lineBreakCollapse = LINE_BREAK_COLLAPSE_STANDING_BY;
                }
            }
        } else {
            if (!this.textWrapping && this.insertFirstExceedWord) {
                this.addWord(textArea, textLength);
                this.wordVestige = null;
                this.insertFirstExceedWord = false;
            }
            if (this.isNewLine && textArea.isEmpty()) {
                if (this.context.isEnableWordbreak()) {
                    this.doWordBreak(word.getValue(), textArea);
                } else {
                    this.addWord(textArea, textLength, wordWidth);
                }
            } else {
                this.wordVestige = null;
                this.remainWord = word;
            }
            textArea.setLineBreak(true);
            this.hasLineBreak = true;
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_STANDING_BY;
        }
    }

    private void doWordBreak(String str, TextArea area) {
        DefaultHyphenationManager hm = new DefaultHyphenationManager();
        Hyphenation wb = hm.getHyphenation(str);
        FontInfo fi = area.getStyle().getFontInfo();
        if (area.getMaxWidth() < 0) {
            this.addWordVestige(area, 1, new WordWidth(fi, wb.getHyphenText(0, 1)), str.substring(1));
            return;
        }
        int endHyphenIndex = this.hyphen(0, area.getMaxWidth() - area.getWidth(), wb, fi);
        if (endHyphenIndex == 0 && area.getWidth() == 0) {
            this.addWordVestige(area, 1, new WordWidth(fi, wb.getHyphenText(0, 1)), str.substring(1));
        } else {
            WordWidth wordWidth = new WordWidth(fi, wb.getHyphenText(0, endHyphenIndex));
            wordWidth = new WordWidth(wordWidth.width + this.textStyle.getLetterSpacing() * (endHyphenIndex - 1), 0);
            this.addWordVestige(area, endHyphenIndex, wordWidth, str.substring(endHyphenIndex));
        }
    }

    private void addWordVestige(TextArea area, int vestigeTextLength, WordWidth vestigeWordWidth, String vestigeString) {
        this.addWord(area, vestigeTextLength, vestigeWordWidth);
        this.wordVestige = vestigeString.length() == 0 ? null : new Word(vestigeString, 0, vestigeString.length());
    }

    private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
        assert (startIndex >= 0);
        if (startIndex > hyphenation.length() - 1) {
            return -1;
        }
        int last = 0;
        int current = 0;
        int i = startIndex + 1;
        while (i < hyphenation.length()) {
            last = current;
            String pre = hyphenation.getHyphenText(startIndex, i);
            current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.textStyle.getLetterSpacing() * pre.length();
            if (width > last && width <= current) {
                return i - 1;
            }
            ++i;
        }
        return hyphenation.length() - 1;
    }

    private WordWidth getWordWidth(FontInfo fontInfo, Word word) {
        return new WordWidth(fontInfo, word.getValue());
    }

    private void addWord(TextArea textArea, int textLength, WordWidth wordWidth) {
        textArea.addWord(textLength, wordWidth);
    }

    private void addWord(TextArea textArea, int textLength) {
        textArea.addWordUsingMaxWidth(textLength);
    }
}

