/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.report.viewer.api.AppContextExtension;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class AppContextUtil {
    public static String APPCONTEXT_EXTENSION_ID = "org.eclipse.birt.report.viewer.appcontext";

    public static List getAppContextExtensionNames() {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] elements = AppContextUtil.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                AppContextExtension appContextExtension;
                String className = elements[i].getAttribute("class");
                if (className != null && (appContextExtension = AppContextUtil.getAppContextExtension(elements[i], className)) != null && appContextExtension.getName() != null) {
                    list.add(appContextExtension.getName());
                }
                ++i;
            }
        }
        return list;
    }

    public static AppContextExtension getAppContextExtensionByName(String appContextName) {
        if (appContextName == null) {
            return null;
        }
        IConfigurationElement[] elements = AppContextUtil.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                AppContextExtension appContextExtension;
                String className = elements[i].getAttribute("class");
                if (className != null && (appContextExtension = AppContextUtil.getAppContextExtension(elements[i], className)) != null && appContextName.equals(appContextExtension.getName())) {
                    return appContextExtension;
                }
                ++i;
            }
        }
        return null;
    }

    public static Map getAppContext(String appContextName, Map appContext) {
        AppContextExtension context = AppContextUtil.getAppContextExtensionByName(appContextName);
        if (context != null) {
            appContext = context.getAppContext(appContext);
        }
        return appContext;
    }

    private static AppContextExtension getAppContextExtension(IConfigurationElement element, String className) {
        if (element == null || className == null) {
            return null;
        }
        String bundleName = AppContextUtil.getContributingPlugin(element);
        if (bundleName != null) {
            try {
                Class clz = AppContextUtil.loadClass(bundleName, className);
                if (clz != null) {
                    return (AppContextExtension)clz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static IConfigurationElement[] getConfigurationElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(APPCONTEXT_EXTENSION_ID);
        if (extensionPoint != null) {
            return extensionPoint.getConfigurationElements();
        }
        return null;
    }

    private static Class loadClass(String bundleName, String className) {
        try {
            Bundle bundle = EclipseUtil.getBundle((String)bundleName);
            if (bundle != null && bundle.getState() == 4) {
                bundle.start(1);
            }
            if (bundle != null) {
                return bundle.loadClass(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getContributingPlugin(IConfigurationElement configurationElement) {
        Object parent = configurationElement;
        while (parent != null) {
            if (parent instanceof IExtension) {
                return ((IExtension)parent).getNamespaceIdentifier();
            }
            parent = parent.getParent();
        }
        return null;
    }
}

