/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class JSMethodRunner {
    private Scriptable scope;
    private ScriptContext cx;
    private static final String METHOD_NAME_PREFIX = "__bm_";

    public JSMethodRunner(ScriptContext cx, Scriptable scope, String scopeName) {
        this.scope = scope;
        this.cx = cx;
    }

    public Object runScript(String methodName, String script) throws BirtException {
        methodName = METHOD_NAME_PREFIX + (String)methodName;
        try {
            if (!this.scope.has((String)methodName, this.scope)) {
                String scriptText = "function " + (String)methodName + "() {\n" + script + "\n} ";
                ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, scriptText, ScriptExpression.defaultID, 1);
            }
            String callScriptText = (String)methodName + "()";
            Object result = ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, callScriptText, ScriptExpression.defaultID, 1);
            return result;
        }
        catch (DataException e) {
            throw new DataException("data.engine.FailToExecuteScript", (Throwable)((Object)e), new Object[]{methodName, script});
        }
    }

    public Object runScript(String methodName, String script, String id) throws BirtException {
        methodName = METHOD_NAME_PREFIX + (String)methodName;
        try {
            if (!this.scope.has((String)methodName, this.scope)) {
                String scriptText = "function " + (String)methodName + "() {\n" + script + "\n} ";
                ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, scriptText, id, 1);
            }
            String callScriptText = (String)methodName + "()";
            Object result = ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.scope, callScriptText, id, 1);
            return result;
        }
        catch (DataException e) {
            throw new DataException("data.engine.FailToExecuteScript", (Throwable)((Object)e), new Object[]{methodName, script});
        }
    }
}

