/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CubeLabelProvider
extends LabelProvider {
    private static final Image IMG_DATASOURCE = ReportPlatformUIImages.getImage((String)"OdaDataSource");
    private static final Image IMG_DATASET = ReportPlatformUIImages.getImage((String)"OdaDataSet");
    private static final Image IMG_DATAFIELD = ReportPlatformUIImages.getImage((String)"DataColumn");
    private static final Image IMG_DATAFIELD_USED = UIHelper.getImage("icons/obj16/data_column_used.gif");
    private static final Image IMG_CUBE = UIHelper.getImage("icons/obj16/cube.gif");
    private static final Image IMG_DIMENSION = UIHelper.getImage("icons/obj16/dimension.gif");
    private static final Image IMG_DIMENSION_FOLDER = UIHelper.getImage("icons/obj16/dimensions.gif");
    private static final Image IMG_MEASUREGROUP_FOLDER = UIHelper.getImage("icons/obj16/measuregroups.gif");
    private static final Image IMG_MEASURE = UIHelper.getImage("icons/obj16/measure_group.gif");
    private static final Image IMG_MEASUREGROUP = UIHelper.getImage("icons/obj16/measure_group.gif");
    private static final Image IMG_DERIVED_MEASURE = UIHelper.getImage("icons/obj16/derived_measure.gif");
    private static final Image IMG_LEVEL = UIHelper.getImage("icons/obj16/level.gif");
    private static final Image IMG_OTHER_DATASETS = UIHelper.getImage("icons/obj16/folder.gif");
    private TabularCubeHandle input;
    private boolean isDataViewer = false;

    public void setInput(TabularCubeHandle input) {
        this.input = input;
    }

    public void setProivderViewer(boolean isDataViewer) {
        this.isDataViewer = isDataViewer;
    }

    public Image getImage(Object element) {
        if (element instanceof DesignElementHandle && ((DesignElementHandle)element).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof DataSourceHandle) {
            return IMG_DATASOURCE;
        }
        if (element instanceof DataSetHandle) {
            return IMG_DATASET;
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("other")) {
            return IMG_OTHER_DATASETS;
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("shared dimensions")) {
            return IMG_DIMENSION_FOLDER;
        }
        if (element instanceof ResultSetColumnHandle) {
            Map<String, List<String>> columnMap = this.getColumnMap();
            ResultSetColumnHandle column = (ResultSetColumnHandle)element;
            String datasetName = ((DataSetHandle)column.getElementHandle()).getName();
            String columnName = column.getColumnName();
            if (columnMap.containsKey(datasetName) && columnMap.get(datasetName).contains(columnName)) {
                return IMG_DATAFIELD_USED;
            }
            return IMG_DATAFIELD;
        }
        if (element instanceof DimensionHandle) {
            return IMG_DIMENSION;
        }
        if (element instanceof LevelHandle) {
            List<DimensionHandle> dimensions;
            if (this.isDataViewer && (dimensions = this.getSharedDimensionHandles()).contains(((LevelHandle)element).getContainer().getContainer())) {
                return IMG_DATAFIELD_USED;
            }
            return IMG_LEVEL;
        }
        if (element instanceof CubeHandle) {
            return IMG_CUBE;
        }
        if (element instanceof MeasureHandle) {
            return ((MeasureHandle)element).isCalculated() ? IMG_DERIVED_MEASURE : IMG_MEASURE;
        }
        if (element instanceof MeasureGroupHandle) {
            return IMG_MEASUREGROUP;
        }
        if (element instanceof String) {
            return IMG_DATAFIELD;
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle model = (PropertyHandle)element;
            if (model.getPropertyDefn().getName().equals("dimensions")) {
                return IMG_DIMENSION_FOLDER;
            }
            if (model.getPropertyDefn().getName().equals("measureGroups")) {
                return IMG_MEASUREGROUP_FOLDER;
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof DataSetHandle) {
            if (this.input != null && this.input.getDataSet() != null && this.input.getDataSet() == element) {
                return ((DataSetHandle)element).getName() + " " + Messages.getString("GroupsPage.Primary.Dataset");
            }
            return ((DataSetHandle)element).getName();
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("other")) {
            return Messages.getString("Cube.Other.Datasets");
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("shared dimensions")) {
            return Messages.getString("CubeLabelProvider.SharedDimensions");
        }
        if (element instanceof ResultSetColumnHandle) {
            return OlapUtil.getDataFieldDisplayName((ResultSetColumnHandle)element);
        }
        if (element instanceof DimensionHandle) {
            return ((DimensionHandle)element).getName();
        }
        if (element instanceof LevelHandle) {
            return ((LevelHandle)element).getName();
        }
        if (element instanceof CubeHandle) {
            return ((CubeHandle)element).getName();
        }
        if (element instanceof MeasureGroupHandle) {
            return ((MeasureGroupHandle)element).getName();
        }
        if (element instanceof MeasureHandle) {
            String name = ((MeasureHandle)element).getDisplayName();
            if (name == null || name.trim().length() == 0) {
                name = ((MeasureHandle)element).getName();
            }
            try {
                if (((MeasureHandle)element).isCalculated()) {
                    return name;
                }
                return name + "(" + DataUtil.getAggregationManager().getAggregation(DataAdapterUtil.adaptModelAggregationType((String)((MeasureHandle)element).getFunction())).getDisplayName() + ")";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof PropertyHandle) {
            PropertyHandle model = (PropertyHandle)element;
            if (model.getPropertyDefn().getName().equals("dimensions")) {
                return Messages.getString("Cube.Groups");
            }
            if (model.getPropertyDefn().getName().equals("measureGroups")) {
                return Messages.getString("Cube.MeasureGroup");
            }
        }
        return super.getText(element);
    }

    public String getToolTip(Object element) {
        return this.getText(element);
    }

    private List<DimensionHandle> getSharedDimensionHandles() {
        ArrayList<DimensionHandle> dimensions = new ArrayList<DimensionHandle>();
        List list = this.input.getContents("dimensions");
        int i = 0;
        while (i < list.size()) {
            DimensionHandle dimension = (DimensionHandle)list.get(i);
            if (dimension instanceof TabularDimensionHandle && ((TabularDimensionHandle)dimension).getSharedDimension() != null) {
                dimension = ((TabularDimensionHandle)dimension).getSharedDimension();
                dimensions.add(dimension);
            }
            ++i;
        }
        return dimensions;
    }

    protected Map<String, List<String>> getColumnMap() {
        int j;
        List<String> columns;
        String dataset;
        HashMap<String, List<String>> columnMap = new HashMap<String, List<String>>();
        if (this.input == null) {
            return columnMap;
        }
        List list = this.input.getContents("dimensions");
        int i = 0;
        while (i < list.size()) {
            TabularHierarchyHandle hierarchy;
            DimensionHandle dimension = (DimensionHandle)list.get(i);
            if (dimension instanceof TabularDimensionHandle && ((TabularDimensionHandle)dimension).getSharedDimension() != null) {
                dimension = ((TabularDimensionHandle)dimension).getSharedDimension();
            }
            if ((hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0)) != null && hierarchy.getLevelCount() > 0) {
                dataset = hierarchy.getDataSet() == null ? this.input.getDataSet().getName() : hierarchy.getDataSet().getName();
                columns = (ArrayList<String>)columnMap.get(dataset);
                if (columns == null) {
                    columns = new ArrayList<String>();
                    columnMap.put(dataset, columns);
                }
                j = 0;
                while (j < hierarchy.getLevelCount()) {
                    TabularLevelHandle level = (TabularLevelHandle)hierarchy.getLevel(j);
                    columns.add(level.getColumnName());
                    ++j;
                }
            }
            ++i;
        }
        list = this.input.getContents("measureGroups");
        i = 0;
        while (i < list.size()) {
            MeasureGroupHandle measureGroup = (MeasureGroupHandle)list.get(i);
            Object[] measures = measureGroup.getContents("measures").toArray();
            if (measures != null) {
                dataset = this.input.getDataSet().getName();
                columns = (List)columnMap.get(dataset);
                if (columns == null) {
                    columns = new ArrayList();
                    columnMap.put(dataset, columns);
                }
                j = 0;
                while (j < measures.length) {
                    TabularMeasureHandle measure = (TabularMeasureHandle)measures[j];
                    try {
                        String columnName = ExpressionUtil.getColumnName((String)measure.getMeasureExpression());
                        if (columnName != null) {
                            columns.add(columnName);
                        }
                    }
                    catch (BirtException birtException) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            ++i;
        }
        return columnMap;
    }
}

