/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class TagRule
extends MultiLineRule {
    public TagRule(IToken token) {
        super("<", ">", token);
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int c = scanner.read();
        if (sequence[0] == '<') {
            if (c == 63) {
                scanner.unread();
                return false;
            }
            if (c == 33) {
                scanner.unread();
                return false;
            }
        } else if (sequence[0] == '>') {
            scanner.unread();
        }
        return super.sequenceDetected(scanner, sequence, eofAllowed);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (c != 62) continue;
            this.endOfTagDetected(scanner);
            return true;
        }
        scanner.unread();
        return false;
    }

    private void endOfTagDetected(ICharacterScanner scanner) {
        int c;
        int scanAhead = 0;
        int endOfTagOffset = 0;
        while ((c = scanner.read()) != -1 && c != 60) {
            ++scanAhead;
            if (c != 62) continue;
            endOfTagOffset = scanAhead;
        }
        if (c == 60) {
            int rewind = scanAhead - endOfTagOffset + 1;
            int i = 0;
            while (i < rewind) {
                scanner.unread();
                ++i;
            }
        }
    }
}

