/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.XSSFCellBorderExtended;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManagerXUtils
extends StyleManagerUtils {
    private static StyleManagerUtils.Factory factory = new StyleManagerUtils.Factory(){

        @Override
        public StyleManagerUtils create(Logger log) {
            return new StyleManagerXUtils(log);
        }
    };

    public static StyleManagerUtils.Factory getFactory() {
        return factory;
    }

    public StyleManagerXUtils(Logger log) {
        super(log);
    }

    @Override
    public RichTextString createRichTextString(String value) {
        XSSFRichTextString result = new XSSFRichTextString(value);
        return result;
    }

    private BorderStyle poiBorderStyleFromBirt(String birtBorder, String width) {
        if ("none".equals(birtBorder)) {
            return BorderStyle.NONE;
        }
        double pxWidth = 3.0;
        if ("thin".equals(width)) {
            pxWidth = 1.0;
        } else if ("medium".equals(width)) {
            pxWidth = 3.0;
        } else if ("thick".equals(width)) {
            pxWidth = 4.0;
        } else {
            DimensionType dim = DimensionType.parserUnit((String)width);
            if (dim != null && "px".equals(dim.getUnits())) {
                pxWidth = dim.getMeasure();
            }
        }
        if ("solid".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return BorderStyle.THIN;
            }
            if (pxWidth < 3.1) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if ("dashed".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return BorderStyle.DASHED;
            }
            return BorderStyle.MEDIUM_DASHED;
        }
        if ("dotted".equals(birtBorder)) {
            return BorderStyle.DOTTED;
        }
        if ("double".equals(birtBorder)) {
            return BorderStyle.DOUBLE;
        }
        this.log.debug("Border style \"", birtBorder, "\" is not recognised.");
        return BorderStyle.NONE;
    }

    private CTBorder getCTBorder(StylesTable stylesSource, CTXf cellXf) {
        CTBorder ct;
        if (cellXf.getApplyBorder()) {
            int idx = (int)cellXf.getBorderId();
            XSSFCellBorder cf = stylesSource.getBorderAt(idx);
            ct = (CTBorder)cf.getCTBorder().copy();
        } else {
            ct = (CTBorder)CTBorder.Factory.newInstance();
        }
        return ct;
    }

    public void setBorderAll(StylesTable stylesSource, CTXf cellXf, ThemesTable theme, BirtStyle birtStyle) {
        String borderTopColor = birtStyle.getProperty(24) == null ? "rgb(0,0,0)" : birtStyle.getProperty(24).getCssText();
        String borderTopStyle = birtStyle.getProperty(49) == null ? "none" : birtStyle.getProperty(49).getCssText();
        String borderTopWidth = birtStyle.getProperty(27) == null ? "medium" : birtStyle.getProperty(27).getCssText();
        String borderBottomColor = birtStyle.getProperty(5) == null ? "rgb(0,0,0)" : birtStyle.getProperty(5).getCssText();
        String borderBottomStyle = birtStyle.getProperty(21) == null ? "none" : birtStyle.getProperty(21).getCssText();
        String borderBottomWidth = birtStyle.getProperty(10) == null ? "medium" : birtStyle.getProperty(10).getCssText();
        String borderLeftColor = birtStyle.getProperty(47) == null ? "rgb(0,0,0)" : birtStyle.getProperty(47).getCssText();
        String borderLeftStyle = birtStyle.getProperty(58) == null ? "none" : birtStyle.getProperty(58).getCssText();
        String borderLeftWidth = birtStyle.getProperty(50) == null ? "medium" : birtStyle.getProperty(50).getCssText();
        String borderRightColor = birtStyle.getProperty(4) == null ? "rgb(0,0,0)" : birtStyle.getProperty(4).getCssText();
        String borderRightStyle = birtStyle.getProperty(20) == null ? "none" : birtStyle.getProperty(20).getCssText();
        String borderRightWidth = birtStyle.getProperty(9) == null ? "medium" : birtStyle.getProperty(9).getCssText();
        String diagonalColor = birtStyle.getProperty(7) == null ? "rgb(0,0,0)" : birtStyle.getProperty(7).getCssText();
        String diagonalStyle = birtStyle.getProperty(22) == null ? "none" : birtStyle.getProperty(22).getCssText();
        String diagonalWidth = birtStyle.getProperty(11) == null ? "medium" : birtStyle.getProperty(11).getCssText();
        String antidiagonalColor = birtStyle.getProperty(14) == null ? "rgb(0,0,0)" : birtStyle.getProperty(14).getCssText();
        String antidiagonalStyle = birtStyle.getProperty(26) == null ? "solid" : birtStyle.getProperty(26).getCssText();
        String antidiagonalWidth = birtStyle.getProperty(18) == null ? "medium" : birtStyle.getProperty(18).getCssText();
        CTBorder ct = this.getCTBorder(stylesSource, cellXf);
        CTBorderPr pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
        BorderStyle border = null;
        XSSFColor xBorderColour = null;
        IndexedColorMap colorMap = stylesSource.getIndexedColors();
        XSSFCellBorderExtended cb = new XSSFCellBorderExtended(ct, theme, colorMap);
        BorderStyle borderDiagonal = this.poiBorderStyleFromBirt(diagonalStyle, diagonalWidth);
        BorderStyle borderAntidiagonal = this.poiBorderStyleFromBirt(antidiagonalStyle, antidiagonalWidth);
        if (borderDiagonal == BorderStyle.NONE && ct.isSetDiagonalDown()) {
            ct.unsetDiagonalDown();
        }
        if (borderAntidiagonal == BorderStyle.NONE && ct.isSetDiagonalUp()) {
            ct.unsetDiagonalUp();
        }
        if (borderDiagonal != BorderStyle.NONE || borderAntidiagonal != BorderStyle.NONE) {
            if (borderDiagonal != BorderStyle.NONE) {
                xBorderColour = this.getXColour(diagonalColor);
                border = borderDiagonal;
                ct.setDiagonalDown(true);
                cb.setDiagonal(true);
                cb.setDiagonalColor(xBorderColour);
                cb.setDiagonalStyle(border);
            }
            if (borderAntidiagonal != BorderStyle.NONE) {
                if (xBorderColour == null) {
                    xBorderColour = this.getXColour(antidiagonalColor);
                }
                if (border == null) {
                    border = borderAntidiagonal;
                }
                ct.setDiagonalUp(true);
                cb.setAntidiagonal(true);
                cb.setAntidiagonalColor(xBorderColour);
                cb.setAntidiagonalStyle(border);
            }
            ct.setDiagonal(pr);
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border.getCode() + 1)));
            pr.addNewColor().setRgb(xBorderColour.getRGB());
        }
        if ((border = this.poiBorderStyleFromBirt(borderTopStyle, borderTopWidth)) != BorderStyle.NONE) {
            xBorderColour = this.getXColour(borderTopColor);
            cb.setBorderStyle(XSSFCellBorder.BorderSide.TOP, border);
            cb.setBorderColor(XSSFCellBorder.BorderSide.TOP, xBorderColour);
        }
        if ((border = this.poiBorderStyleFromBirt(borderBottomStyle, borderBottomWidth)) != BorderStyle.NONE) {
            xBorderColour = this.getXColour(borderBottomColor);
            cb.setBorderStyle(XSSFCellBorder.BorderSide.BOTTOM, border);
            cb.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, xBorderColour);
        }
        if ((border = this.poiBorderStyleFromBirt(borderLeftStyle, borderLeftWidth)) != BorderStyle.NONE) {
            xBorderColour = this.getXColour(borderLeftColor);
            cb.setBorderStyle(XSSFCellBorder.BorderSide.LEFT, border);
            cb.setBorderColor(XSSFCellBorder.BorderSide.LEFT, xBorderColour);
        }
        if ((border = this.poiBorderStyleFromBirt(borderRightStyle, borderRightWidth)) != BorderStyle.NONE) {
            xBorderColour = this.getXColour(borderRightColor);
            cb.setBorderStyle(XSSFCellBorder.BorderSide.RIGHT, border);
            cb.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, xBorderColour);
        }
        int idx = stylesSource.putBorder((XSSFCellBorder)cb);
        cellXf.setBorderId((long)idx);
        cellXf.setApplyBorder(true);
    }

    @Override
    public void applyBorderStyle(Workbook workbook, CellStyle style, XSSFCellBorder.BorderSide side, CSSValue colour, CSSValue borderStyle, CSSValue width) {
    }

    @Override
    public void applyBorderStyle(Workbook workbook, CellStyle style, BirtStyle birtStyle) {
        this.applyBorderStyleToCell(workbook, style, birtStyle);
    }

    private void applyBorderStyleToCell(Workbook workbook, CellStyle style, BirtStyle birtStyle) {
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            StylesTable stylesSource = null;
            if (stylesSource == null) {
                if (workbook instanceof SXSSFWorkbook) {
                    stylesSource = ((SXSSFWorkbook)workbook).getXSSFWorkbook().getStylesSource();
                } else if (workbook instanceof XSSFWorkbook) {
                    stylesSource = ((XSSFWorkbook)workbook).getStylesSource();
                }
            }
            if (stylesSource != null) {
                ThemesTable theme = stylesSource.getTheme();
                CTXf cellXf = xStyle.getCoreXf();
                this.setBorderAll(stylesSource, cellXf, theme, birtStyle);
            }
        }
    }

    private XSSFColor getXColour(String colour) {
        int[] rgbInt = ColorUtil.getRGBs((String)colour);
        if (rgbInt == null) {
            return null;
        }
        byte[] rgbByte = new byte[]{-1, (byte)rgbInt[0], (byte)rgbInt[1], (byte)rgbInt[2]};
        DefaultIndexedColorMap colorMap = new DefaultIndexedColorMap();
        XSSFColor result = new XSSFColor(rgbByte, (IndexedColorMap)colorMap);
        return result;
    }

    @Override
    public void addColourToFont(Workbook workbook, Font font, String colour) {
        if (colour == null || CSSValueConstants.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (font instanceof XSSFFont) {
            XSSFFont xFont = (XSSFFont)font;
            XSSFColor xColour = this.getXColour(colour);
            if (xColour != null) {
                xFont.setColor(xColour);
            }
        }
    }

    @Override
    public void addBackgroundColourToStyle(Workbook workbook, CellStyle style, String colour) {
        if (colour == null || CSSValueConstants.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle cellStyle = (XSSFCellStyle)style;
            XSSFColor xColour = this.getXColour(colour);
            if (xColour != null) {
                cellStyle.setFillForegroundColor(xColour);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
    }

    @Override
    public Font correctFontColorIfBackground(FontManager fm, Workbook wb, BirtStyle birtStyle, Font font) {
        CSSValue bgColour = birtStyle.getProperty(40);
        int[] bgRgb = this.parseColour(bgColour == null ? null : bgColour.getCssText(), "white");
        XSSFColor colour = ((XSSFFont)font).getXSSFColor();
        int[] fgRgb = this.rgbOnly(colour.getARGB());
        if (fgRgb[0] == 255 && fgRgb[1] == 255 && fgRgb[2] == 255) {
            fgRgb[2] = 0;
            fgRgb[1] = 0;
            fgRgb[0] = 0;
        } else if (fgRgb[0] == 0 && fgRgb[1] == 0 && fgRgb[2] == 0) {
            fgRgb[2] = 255;
            fgRgb[1] = 255;
            fgRgb[0] = 255;
        }
        if (bgRgb[0] == fgRgb[0] && bgRgb[1] == fgRgb[1] && bgRgb[2] == fgRgb[2]) {
            AreaStyle addedStyle = new AreaStyle(fm.getCssEngine());
            addedStyle.setColor(this.contrastColour(bgRgb));
            return fm.getFontWithExtraStyle(font, (IStyle)addedStyle);
        }
        return font;
    }

    @Override
    public int anchorDxFromMM(double widthMM, double colWidthMM) {
        return (int)(widthMM * 36000.0);
    }

    @Override
    public int anchorDyFromPoints(float height, float rowHeight) {
        return (int)(height * 12700.0f);
    }

    @Override
    public void prepareMarginDimensions(Sheet sheet, IPageContent page) {
        double headerHeight = 0.5;
        double footerHeight = 0.5;
        if (page.getHeaderHeight() != null && this.isAbsolute(page.getHeaderHeight())) {
            headerHeight = page.getHeaderHeight().convertTo("in");
            sheet.setMargin((short)4, headerHeight);
        }
        if (page.getFooterHeight() != null && this.isAbsolute(page.getFooterHeight())) {
            footerHeight = page.getFooterHeight().convertTo("in");
            sheet.setMargin((short)5, footerHeight);
        }
        if (page.getMarginBottom() != null && this.isAbsolute(page.getMarginBottom())) {
            sheet.setMargin((short)3, footerHeight + page.getMarginBottom().convertTo("in"));
        }
        if (page.getMarginLeft() != null && this.isAbsolute(page.getMarginLeft())) {
            sheet.setMargin((short)0, page.getMarginLeft().convertTo("in"));
        }
        if (page.getMarginRight() != null && this.isAbsolute(page.getMarginRight())) {
            sheet.setMargin((short)1, page.getMarginRight().convertTo("in"));
        }
        if (page.getMarginTop() != null && this.isAbsolute(page.getMarginTop())) {
            sheet.setMargin((short)2, headerHeight + page.getMarginTop().convertTo("in"));
        }
    }
}

