/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MethodParameterType {
    private static MethodParameterType[] builtinTypes = new MethodParameterType[]{new MethodParameterType("boolean", Boolean.TYPE, "Boolean"), new MethodParameterType("byte", Byte.TYPE, "Integer"), new MethodParameterType("char", Character.TYPE, "Integer"), new MethodParameterType("double", Double.TYPE, "Double"), new MethodParameterType("float", Float.TYPE, "Double"), new MethodParameterType("int", Integer.TYPE, "Integer"), new MethodParameterType("long", Long.TYPE, "Double"), new MethodParameterType("short", Short.TYPE, "Integer"), new MethodParameterType("java.lang.Boolean", Boolean.class, "Boolean"), new MethodParameterType("java.lang.Byte", Byte.class, "Integer"), new MethodParameterType("java.lang.Character", Character.class, "Integer"), new MethodParameterType("java.lang.Double", Double.class, "Double"), new MethodParameterType("java.lang.Float", Float.class, "Double"), new MethodParameterType("java.lang.Integer", Integer.class, "Integer"), new MethodParameterType("java.lang.Long", Long.class, "Double"), new MethodParameterType("java.lang.Short", Short.class, "Integer"), new MethodParameterType("java.lang.String", String.class, "String"), new MethodParameterType("java.math.BigDecimal", BigDecimal.class, "Decimal"), new MethodParameterType("java.sql.Date", java.sql.Date.class, "Date"), new MethodParameterType("java.sql.Time", Time.class, "Time"), new MethodParameterType("java.sql.Timestamp", Timestamp.class, "Timestamp"), new MethodParameterType("java.util.Date", Date.class, "Date")};
    private static Map<Class, MethodParameterType> classInstanceMap = new HashMap<Class, MethodParameterType>();
    private static Map<String, MethodParameterType> nameInstanceMap = new HashMap<String, MethodParameterType>();
    private String name;
    private Class javaType;
    private String nativeOdaDataTypeName;

    static {
        MethodParameterType[] methodParameterTypeArray = builtinTypes;
        int n = builtinTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameterType pt = methodParameterTypeArray[n2];
            classInstanceMap.put(pt.getJavaType(), pt);
            nameInstanceMap.put(pt.getName(), pt);
            ++n2;
        }
    }

    public String getNativeOdaDataTypeName() {
        return this.nativeOdaDataTypeName;
    }

    private MethodParameterType(String name, Class javaType, String nativeOdaDataTypeName) {
        this.name = name;
        this.javaType = javaType;
        this.nativeOdaDataTypeName = nativeOdaDataTypeName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public static MethodParameterType getInstance(String name, ClassLoader pojoClassLoader) throws OdaException {
        Class<?> c2;
        MethodParameterType result = nameInstanceMap.get(name);
        if (result == null) {
            try {
                c2 = Class.forName(name);
                result = classInstanceMap.get(c2);
            }
            catch (ClassNotFoundException c2) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                c2 = pojoClassLoader.loadClass(name);
                result = new MethodParameterType(name, c2, "Java Object");
            }
            catch (ClassNotFoundException e) {
                throw new OdaException((Throwable)e);
            }
        }
        return result;
    }

    public static MethodParameterType getInstance(Class c) {
        MethodParameterType result = classInstanceMap.get(c);
        if (result == null) {
            result = new MethodParameterType(c.getName(), c, "Java Object");
        }
        return result;
    }

    public static MethodParameterType[] getBuiltins() {
        return builtinTypes;
    }

    public static String getNativeOdaDataTypeName(String name) {
        MethodParameterType mpt = nameInstanceMap.get(name);
        if (mpt != null) {
            return mpt.getNativeOdaDataTypeName();
        }
        try {
            Class<?> c = Class.forName(name);
            mpt = classInstanceMap.get(c);
            if (mpt != null) {
                return mpt.getNativeOdaDataTypeName();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return "Java Object";
    }
}

