/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public abstract class Layout {
    protected ContainerLayout parent;
    protected LayoutEngineContext context;
    protected IContent content;
    protected int specifiedWidth;
    protected int specifiedHeight;
    protected static Logger logger = Logger.getLogger(Layout.class.getName());

    public Layout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        this.context = context;
        this.parent = parent;
        this.content = content;
    }

    public abstract void layout() throws BirtException;

    protected abstract void initialize() throws BirtException;

    protected abstract void closeLayout() throws BirtException;

    protected void calculateSpecifiedWidth() {
        if (this.content != null) {
            this.specifiedWidth = this.parent != null ? this.getDimensionValue(this.content.getWidth(), this.parent.getCurrentMaxContentWidth()) : this.getDimensionValue(this.content.getWidth());
        }
    }

    protected void calculateSpecifiedHeight() {
        if (this.content != null) {
            this.specifiedHeight = this.getDimensionValue(this.content.getHeight());
        }
    }

    protected int getDimensionValue(CSSValue value) {
        return this.getDimensionValue(value, 0);
    }

    protected void validateBoxProperty(IContent content, IStyle style, int maxWidth, int maxHeight) {
        if (content == null) {
            return;
        }
        IStyle contentStyle = content.getStyle();
        if (contentStyle == null || contentStyle.isEmpty()) {
            return;
        }
        this.validateBoxProperty(style, maxWidth, maxHeight);
    }

    protected void validateBoxProperty(IStyle style, int maxWidth, int maxHeight) {
        int leftMargin = this.getDimensionValue(style.getProperty(0), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(1), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(6), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(2), maxWidth);
        int leftPadding = Math.max(0, this.getDimensionValue(style.getProperty(12), maxWidth));
        int rightPadding = Math.max(0, this.getDimensionValue(style.getProperty(16), maxWidth));
        int topPadding = Math.max(0, this.getDimensionValue(style.getProperty(19), maxWidth));
        int bottomPadding = Math.max(0, this.getDimensionValue(style.getProperty(13), maxWidth));
        int leftBorder = Math.max(0, this.getDimensionValue(style.getProperty(50), 0));
        int rightBorder = Math.max(0, this.getDimensionValue(style.getProperty(9), 0));
        int topBorder = Math.max(0, this.getDimensionValue(style.getProperty(27), 0));
        int bottomBorder = Math.max(0, this.getDimensionValue(style.getProperty(10), 0));
        int[] vs = new int[]{rightMargin, leftMargin, rightPadding, leftPadding, rightBorder, leftBorder};
        this.resolveBoxConflict(vs, maxWidth);
        int[] hs = new int[]{bottomMargin, topMargin, bottomPadding, topPadding, bottomBorder, topBorder};
        style.setProperty(0, new FloatValue(1, vs[1]));
        style.setProperty(1, new FloatValue(1, vs[0]));
        style.setProperty(6, new FloatValue(1, hs[1]));
        style.setProperty(2, new FloatValue(1, hs[0]));
        style.setProperty(12, new FloatValue(1, vs[3]));
        style.setProperty(16, new FloatValue(1, vs[2]));
        style.setProperty(19, new FloatValue(1, hs[3]));
        style.setProperty(13, new FloatValue(1, hs[2]));
        style.setProperty(50, new FloatValue(1, vs[5]));
        style.setProperty(9, new FloatValue(1, vs[4]));
        style.setProperty(27, new FloatValue(1, hs[5]));
        style.setProperty(10, new FloatValue(1, hs[4]));
    }

    private void resolveConflict(int[] values, int maxTotal, int total, int start) {
        int length = values.length - start;
        if (length == 0) {
            return;
        }
        assert (length > 0);
        if (total > maxTotal) {
            int othersTotal = total - values[start];
            if (values[start] > 0) {
                values[start] = 0;
            }
            this.resolveConflict(values, maxTotal, othersTotal, start + 1);
        }
    }

    protected int getDimensionValue(String d) {
        if (d == null) {
            return 0;
        }
        try {
            if (d.endsWith("in") || d.endsWith("in")) {
                return (int)(Float.parseFloat(d.substring(0, d.length() - 2)) * 72000.0f);
            }
            if (d.endsWith("cm") || d.endsWith("CM")) {
                return (int)(Float.parseFloat(d.substring(0, d.length() - 2)) * 72000.0f / 2.54f);
            }
            if (d.endsWith("mm") || d.endsWith("MM")) {
                return (int)(Float.parseFloat(d.substring(0, d.length() - 2)) * 7200.0f / 2.54f);
            }
            if (d.endsWith("px") || d.endsWith("PX")) {
                return (int)(Float.parseFloat(d.substring(0, d.length() - 2)) / 96.0f * 72000.0f);
            }
            return (int)Float.parseFloat(d);
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage());
            return 0;
        }
    }

    protected int getDimensionValue(DimensionType d) {
        return this.getDimensionValue(d, 0);
    }

    protected int getDimensionValue(DimensionType d, int referenceLength) {
        return this.getDimensionValue(d, 0, referenceLength);
    }

    protected int getDimensionValue(DimensionType d, int dpi, int referenceLength) {
        if (d == null) {
            return 0;
        }
        try {
            String units = d.getUnits();
            if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                double point = d.convertTo("pt") * 1000.0;
                return (int)point;
            }
            if (units.equals("px")) {
                if (dpi == 0) {
                    dpi = this.getResolution();
                }
                double point = d.getMeasure() / (double)dpi * 72000.0;
                return (int)point;
            }
            if (units.equals("%")) {
                double point = (double)referenceLength * d.getMeasure() / 100.0;
                return (int)point;
            }
            if (units.equals("em") || units.equals("ex")) {
                int size = 9000;
                if (this.content != null) {
                    IStyle style = this.content.getComputedStyle();
                    CSSValue fontSize = style.getProperty(53);
                    size = this.getDimensionValue(fontSize);
                }
                double point = (double)size * d.getMeasure();
                return (int)point;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return 0;
        }
        return 0;
    }

    protected int getResolution() {
        ReportDesignHandle designHandle = this.content.getReportContent().getDesign().getReportDesign();
        int resolution = designHandle.getImageDPI();
        if (resolution == 0) {
            resolution = this.context.getDpi();
        }
        if (resolution == 0) {
            resolution = 96;
        }
        return resolution;
    }

    protected void resolveBoxConflict(int[] vs, int max) {
        int vTotal = 0;
        int i = 0;
        while (i < vs.length) {
            vTotal += vs[i];
            ++i;
        }
        this.resolveConflict(vs, max, vTotal, 0);
    }

    protected int getDimensionValue(CSSValue value, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((double)((float)referenceLength * v) / 100.0);
                }
            }
        }
        return 0;
    }

    protected TableLayout getTableLayoutManager() {
        ContainerLayout lm = this.parent;
        while (lm != null && !(lm instanceof TableLayout)) {
            lm = lm.getParent();
        }
        if (lm == null) assert (false);
        return (TableLayout)lm;
    }

    public ContainerLayout getParent() {
        return this.parent;
    }

    protected void removeMargin(IStyle style) {
        if (style != null) {
            style.setProperty(0, IStyle.NUMBER_0);
            style.setProperty(1, IStyle.NUMBER_0);
            style.setProperty(6, IStyle.NUMBER_0);
            style.setProperty(2, IStyle.NUMBER_0);
        }
    }

    protected void visitContent(IContent content, IContentEmitter emitter) throws BirtException {
        ContentEmitterUtil.startContent(content, emitter);
        Collection children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
        ContentEmitterUtil.endContent(content, emitter);
    }
}

