/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteContainer
extends PaletteEntry {
    public static final String PROPERTY_CHILDREN = "Children Changed";
    protected List<PaletteEntry> children = new ArrayList<PaletteEntry>();

    protected PaletteContainer(String label, String desc, ImageDescriptor icon, Object type) {
        super(label, desc, icon, null, type);
    }

    public boolean acceptsType(Object type) {
        return true;
    }

    public void add(PaletteEntry entry) {
        this.add(-1, entry);
    }

    public void add(int index, PaletteEntry entry) {
        if (!this.acceptsType(entry.getType())) {
            throw new IllegalArgumentException("This container can not contain this type of child: " + String.valueOf(entry.getType()));
        }
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.getChildren());
        int actualIndex = index < 0 ? this.getChildren().size() : index;
        this.getChildren().add(actualIndex, entry);
        entry.setParent(this);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    public void addAll(List<PaletteEntry> list) {
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.getChildren());
        for (PaletteEntry element : list) {
            PaletteEntry child = element;
            if (!this.acceptsType(child.getType())) {
                throw new IllegalArgumentException("This container can not contain this type of child: " + String.valueOf(child.getType()));
            }
            this.getChildren().add(child);
            child.setParent(this);
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    public void appendToSection(String id, PaletteEntry entry) {
        boolean found = false;
        int i = 0;
        while (i < this.getChildren().size()) {
            PaletteEntry currEntry = this.getChildren().get(i);
            if (currEntry.getId().equals(id)) {
                found = true;
            } else if (found && currEntry instanceof PaletteSeparator) {
                this.add(i, entry);
                return;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("Section not found: " + id);
        }
        this.add(entry);
    }

    public List<PaletteEntry> getChildren() {
        return this.children;
    }

    /*
     * WARNING - void declaration
     */
    private boolean move(PaletteEntry entry, boolean up) {
        int index = this.getChildren().indexOf(entry);
        if (index < 0) {
            return false;
        }
        int n = index = up ? index - 1 : index + 1;
        if (index < 0 || index >= this.getChildren().size()) {
            return false;
        }
        PaletteEntry paletteEntry = this.getChildren().get(index);
        if (paletteEntry instanceof PaletteContainer) {
            void container;
            PaletteContainer paletteContainer = (PaletteContainer)paletteEntry;
            PaletteContainer cfr_ignored_0 = (PaletteContainer)paletteEntry;
            if (this.getUserModificationPermission() == 15 && container.acceptsType(entry.getType()) && container.getUserModificationPermission() == 15) {
                this.remove(entry);
                if (up) {
                    container.add(entry);
                } else {
                    container.add(0, entry);
                }
                return true;
            }
        }
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.getChildren());
        this.getChildren().remove(entry);
        this.getChildren().add(index, entry);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
        return true;
    }

    public boolean moveDown(PaletteEntry entry) {
        return this.move(entry, false);
    }

    public boolean moveUp(PaletteEntry entry) {
        return this.move(entry, true);
    }

    public void remove(PaletteEntry entry) {
        ArrayList<PaletteEntry> oldChildren = new ArrayList<PaletteEntry>(this.getChildren());
        if (this.getChildren().remove(entry)) {
            entry.setParent(null);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
        }
    }

    public void setChildren(List<PaletteEntry> list) {
        List<PaletteEntry> oldChildren = this.children;
        oldChildren.forEach(entry -> entry.setParent(null));
        this.children = list;
        this.children.forEach(entry -> entry.setParent(this));
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    @Override
    public String toString() {
        return "Palette Container (" + (this.getLabel() != null ? this.getLabel() : "") + ")";
    }
}

