/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.preview.parameter.AbstractParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.CascadingGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParameter;
import org.eclipse.birt.report.designer.ui.preview.parameter.ListingParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.RadioParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.ScalarParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.StaticTextParam;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParameterDialog
extends Dialog {
    private Composite container;
    private List params;
    private Map paramValues = new HashMap();
    private ScrolledComposite scroller;
    private List isRequiredParameters = new ArrayList();
    private List dataTypeCheckList = new ArrayList();
    private Shell parentShell;
    private static IParameterSelectionChoice nullValueChoice = new IParameterSelectionChoice(){

        public String getLabel() {
            return "Null Value";
        }

        public Object getValue() {
            return null;
        }
    };
    private static IParameterSelectionChoice blankValueChoice = new IParameterSelectionChoice(){

        public String getLabel() {
            return "";
        }

        public Object getValue() {
            return "";
        }
    };

    public InputParameterDialog(Shell parentShell, List params, Map paramValues) {
        super(parentShell);
        this.parentShell = parentShell;
        this.params = params;
        if (paramValues != null) {
            this.paramValues.putAll(paramValues);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object paramValue;
            for (String paramName : this.isRequiredParameters) {
                paramValue = this.paramValues.get(paramName);
                if (paramValue != null && (!(paramValue instanceof String) || !((String)paramValue).equals(""))) continue;
                MessageDialog.openError((Shell)this.parentShell, (String)"Error", (String)(paramName + " cannot be NULL or blank"));
                return;
            }
            for (ScalarParam scalarParam : this.dataTypeCheckList) {
                paramValue = (String)this.paramValues.get(scalarParam.getHandle().getName());
                try {
                    this.paramValues.put(scalarParam.getHandle().getName(), scalarParam.converToDataType(paramValue));
                }
                catch (BirtException e) {
                    MessageDialog.openError((Shell)this.parentShell, (String)"Invalid value type", (String)("The value \"" + paramValue + "\" is invalid with type " + scalarParam.getHandle().getDataType()));
                    return;
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        parent.setLayout((Layout)gridLayout);
        this.scroller = new ScrolledComposite(parent, 2816);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.setLayoutData((Object)new GridData(1808));
        this.createParameters();
        return super.createDialogArea(parent);
    }

    private void createParameters() {
        if (this.container != null && !this.container.isDisposed()) {
            this.container.dispose();
        }
        this.container = new Composite((Composite)this.scroller, 0);
        this.scroller.setContent((Control)this.container);
        this.container.setLayoutData((Object)new GridData(1808));
        this.container.setLayout((Layout)new GridLayout());
        this.createParametersSection(this.params, this.container);
        this.container.setSize(this.container.computeSize(-1, -1));
        this.scroller.setMinSize(this.container.computeSize(-1, -1));
    }

    private void createParametersSection(List children, Composite parent) {
        for (Object obj : children) {
            if (obj instanceof ScalarParam && !((ScalarParam)obj).getHandle().isHidden()) {
                ScalarParam param = (ScalarParam)obj;
                this.createParamSection(param, parent);
                continue;
            }
            if (!(obj instanceof AbstractParamGroup)) continue;
            AbstractParamGroup group = (AbstractParamGroup)obj;
            this.createParametersSection(group.getChildren(), this.createParamGroupSection(group, parent));
        }
    }

    private Composite createParamGroupSection(AbstractParamGroup paramGroup, Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(paramGroup.getHandle().getDisplayLabel());
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    private Composite createParamSection(ScalarParam param, Composite parent) {
        boolean isRequired = param.getHandle().isRequired();
        boolean isStringType = param.getHandle().getDataType().equals("string");
        if (isRequired) {
            this.isRequiredParameters.add(param.getHandle().getName());
        }
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText(param.getHandle().getDisplayLabel() + ":");
        if (param instanceof StaticTextParam) {
            final StaticTextParam textParam = (StaticTextParam)param;
            String value = textParam.getDefaultValue();
            this.dataTypeCheckList.add(textParam);
            Text input = new Text(container, 2048);
            input.setLayoutData((Object)new GridData(768));
            input.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text input = (Text)e.getSource();
                    InputParameterDialog.this.paramValues.put(textParam.getHandle().getName(), input.getText());
                }
            });
            if (this.paramValues.containsKey(textParam.getHandle().getName())) {
                value = this.paramValues.get(textParam.getHandle().getName()).toString();
            }
            if (value != null) {
                input.setText(value);
            }
        } else if (param instanceof RadioParam) {
            final RadioParam radioParam = (RadioParam)param;
            Object value = null;
            try {
                value = radioParam.converToDataType((Object)radioParam.getDefaultValue());
            }
            catch (BirtException input) {
                // empty catch block
            }
            if (this.paramValues.containsKey(radioParam.getHandle().getName())) {
                value = this.paramValues.get(radioParam.getHandle().getName());
            }
            List list = radioParam.getValueList();
            if (!isRequired) {
                list.add(nullValueChoice);
            }
            int i = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (i > 0) {
                    new Label(container, 0);
                }
                IParameterSelectionChoice choice = (IParameterSelectionChoice)iterator.next();
                Button button = new Button(container, 16);
                button.setText(choice.getLabel());
                button.setData(choice.getValue());
                if (choice.getValue() != null && choice.getValue().equals(value)) {
                    button.setSelection(true);
                } else if (value == null && choice.getLabel().equals("Null Value")) {
                    button.setSelection(true);
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        InputParameterDialog.this.paramValues.put(radioParam.getHandle().getName(), button.getData());
                    }
                });
                ++i;
            }
        } else if (param instanceof ListingParam) {
            final ListingParam listParam = (ListingParam)param;
            Object value = null;
            try {
                value = listParam.converToDataType((Object)listParam.getDefaultValue());
            }
            catch (BirtException list) {
                // empty catch block
            }
            if (this.paramValues.containsKey(listParam.getHandle().getName()) && (value = this.paramValues.get(listParam.getHandle().getName())) != null) {
                listParam.setSelectionValue(value.toString());
            }
            Combo combo = new Combo(container, 2048);
            combo.setLayoutData((Object)new GridData(768));
            combo.setVisibleItemCount(30);
            List<IParameterSelectionChoice> list = new ArrayList<IParameterSelectionChoice>();
            if (isStringType && !isRequired) {
                list.add(blankValueChoice);
                list.addAll(listParam.getValueList());
            } else {
                list = listParam.getValueList();
            }
            if (!isRequired) {
                list.add(nullValueChoice);
            }
            for (IParameterSelectionChoice choice : list) {
                String label = (String)(choice.getLabel() == null ? choice.getValue() : choice.getLabel());
                if (label == null) continue;
                combo.add(label);
                combo.setData(label, choice.getValue());
            }
            if (value == null && !isRequired) {
                combo.select(combo.getItemCount() - 1);
            } else {
                int i = 0;
                while (i < combo.getItemCount()) {
                    if (combo.getData(combo.getItem(i)).equals(value)) {
                        combo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    CascadingGroup group;
                    Combo combo = (Combo)e.getSource();
                    InputParameterDialog.this.paramValues.put(listParam.getHandle().getName(), combo.getData(combo.getItem(combo.getSelectionIndex())));
                    if (listParam.getParentGroup() instanceof CascadingGroup && (group = (CascadingGroup)listParam.getParentGroup()).getPostParameter((IParameter)listParam) != null) {
                        try {
                            InputParameterDialog.this.createParameters();
                        }
                        catch (RuntimeException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Input parameters");
        newShell.setSize(400, 400);
    }

    public Map getParameters() {
        return this.paramValues;
    }
}

