/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.elements.table.BasicLayoutStrategies;
import org.eclipse.birt.report.model.api.elements.table.LayoutChangedEvent;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableItem;

public class LayoutRecordTask
extends RecordTask {
    private Module module;

    public LayoutRecordTask(Module module, ReportItem compoundElement) {
        super(compoundElement);
        this.module = module;
    }

    protected final boolean holdTask(Stack<CompoundRecord> transStack) {
        CompoundRecord cr;
        return transStack != null && !transStack.isEmpty() && (cr = transStack.peek()) instanceof LayoutCompoundRecord;
    }

    @Override
    public void doTask(ActivityRecord record, Stack<CompoundRecord> transStack) {
        if (this.holdTask(transStack)) {
            return;
        }
        ReportItem compoundElement = (ReportItem)this.getTarget();
        if (compoundElement instanceof TableItem) {
            TableItem table = (TableItem)compoundElement;
            table.refreshRenderModel(this.module);
            BasicLayoutStrategies.appliesStrategies(table.getLayoutModel(this.module), false);
        }
        LayoutChangedEvent event = new LayoutChangedEvent(compoundElement);
        compoundElement.broadcast(event);
    }
}

