/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.taglib.AbstractViewerTag;
import org.eclipse.birt.report.taglib.component.ParameterField;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ReportTag
extends AbstractViewerTag {
    private static final long serialVersionUID = -5017824486972742042L;
    private String outputFormat;
    private String emitterId;
    private boolean reportServiceInitialized;
    private IViewerReportDesignHandle reportDesignHandle;
    private InputOptions options;

    @Override
    public void __process() throws Exception {
        boolean isIFrame = true;
        this.reportServiceInitialized = false;
        if ("div".equalsIgnoreCase(this.viewer.getReportContainer())) {
            isIFrame = false;
        }
        this.outputFormat = BirtTagUtil.getFormat(this.viewer.getFormat());
        this.emitterId = this.viewer.getEmitterId();
        if (this.emitterId != null && !"".equals(this.emitterId)) {
            this.initializeReportService();
            String emitterFormat = ParameterAccessor.getEmitterFormat(this.emitterId);
            if (emitterFormat != null) {
                this.outputFormat = emitterFormat;
            }
        } else {
            this.emitterId = null;
        }
        if (!this.outputFormat.equalsIgnoreCase("html")) {
            isIFrame = true;
        }
        if (isIFrame) {
            this.__processWithIFrame();
        } else {
            this.__processWithDiv();
        }
    }

    private void __processWithDiv() throws BirtException, Exception, IOException {
        if (!this.reportServiceInitialized) {
            this.initializeReportService();
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        IViewingSession session = ViewingSessionUtil.createSession(request);
        session.lock();
        try {
            this.options = new InputOptions();
            this.options.setOption("request", request);
            this.options.setOption("locale", this.locale);
            this.options.setOption("timeZone", this.timeZone);
            this.options.setOption("rtl", Boolean.valueOf(this.viewer.getRtl()));
            this.options.setOption("isMasterPageContent", Boolean.valueOf(this.viewer.getAllowMasterPage()));
            this.options.setOption("svgFlag", Boolean.valueOf(this.viewer.getSvg()));
            this.options.setOption("format", this.outputFormat);
            this.options.setOption("emitterId", this.emitterId);
            this.options.setOption("isDesigner", false);
            this.options.setOption("servletPath", "/preview");
            this.options.setOption("pageOverflow", this.viewer.getPageOverflow());
            this.reportDesignHandle = BirtTagUtil.getDesignHandle(request, this.viewer);
            if (this.viewer.isHostPage()) {
                HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
                this.__handleOutputReport((OutputStream)response.getOutputStream(), session);
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.__handleOutputReport(out, session);
                String content = out.toString();
                JspWriter writer = this.pageContext.getOut();
                writer.write(this.__handleStyle(content));
                writer.write(this.__handleScript(content));
                writer.write("<div id='" + this.viewer.getId() + "'" + this.__handleDivAppearance() + ">\n");
                writer.write("<div class='" + this.__handleBodyStyle(content) + "'>\n");
                writer.write(this.__handleBody(content) + "\n");
                writer.write("</div>\n");
                writer.write("</div>\n");
            }
        }
        finally {
            session.unlock();
        }
    }

    private void initializeReportService() throws BirtException {
        if (!this.reportServiceInitialized) {
            BirtReportServiceFactory.getReportService().setContext(this.pageContext.getServletContext(), null);
            this.reportServiceInitialized = true;
        }
    }

    private void __processWithIFrame() throws Exception {
        if (this.viewer.isHostPage()) {
            this.__handleIFrame(this.viewer.createURI("preview", null), null);
        } else {
            this.__handleIFrame(this.viewer.createURI("preview", null), this.viewer.getId());
        }
    }

    protected String __handleDivAppearance() {
        Object style = " style='";
        if (this.viewer.getPosition() != null) {
            style = (String)style + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            style = (String)style + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            style = (String)style + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            style = (String)style + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            style = (String)style + "left:" + this.viewer.getLeft() + "px;";
        }
        if ("yes".equalsIgnoreCase(this.viewer.getScrolling())) {
            style = (String)style + "overflow:scroll";
        } else if ("auto".equalsIgnoreCase(this.viewer.getScrolling())) {
            style = (String)style + "overflow:auto";
        }
        if (this.viewer.getStyle() != null) {
            style = (String)style + this.viewer.getStyle() + ";";
        }
        style = (String)style + "' ";
        return style;
    }

    protected String __handleStyle(String content) throws Exception {
        Object style = "";
        if (content == null) {
            return style;
        }
        Pattern p = Pattern.compile("<\\s*style[^\\>]*\\>", 2);
        Matcher m = p.matcher(content);
        while (m.find()) {
            int start = m.end();
            int end = content.toLowerCase().indexOf("</style>", start);
            style = (String)style + content.substring(start + 1, end) + "\n";
        }
        style = ((String)style).replaceAll(".style", ".style" + this.viewer.getId());
        style = "<style type=\"text/css\">\n" + (String)style + "\n</style>\n";
        return style;
    }

    protected String __handleBodyStyle(String content) {
        String bodyStyleId = "";
        if (content == null) {
            return bodyStyleId;
        }
        Pattern p = Pattern.compile("<\\s*body([^\\>]*)\\>", 2);
        Matcher m = p.matcher(content);
        if (m.find()) {
            int i = 1;
            while (i < m.groupCount() + 1) {
                Pattern pl;
                Matcher ml;
                String group = m.group(i);
                if (group != null && (ml = (pl = Pattern.compile("class\\s*=\\s*\"([^\"]+)\"", 2)).matcher(group.trim())).find()) {
                    bodyStyleId = ml.group(1).trim();
                    break;
                }
                ++i;
            }
        }
        bodyStyleId = bodyStyleId.replaceAll("style", "style" + this.viewer.getId());
        return bodyStyleId;
    }

    protected String __handleScript(String content) {
        int end;
        int start;
        Object script = "";
        if (content == null) {
            return script;
        }
        Object head = this.__handleHead(content);
        if (head == null) {
            return script;
        }
        Pattern p = Pattern.compile("<\\s*!--");
        Matcher m = p.matcher((CharSequence)head);
        while (m.find()) {
            start = m.start();
            end = ((String)head).indexOf("-->", start);
            if (end <= 0) continue;
            String preTemp = ((String)head).substring(0, start);
            String lastTemp = ((String)head).substring(end + 3);
            head = preTemp + lastTemp;
        }
        p = Pattern.compile("<\\s*script[^\\>]*\\>", 2);
        m = p.matcher((CharSequence)head);
        while (m.find()) {
            start = m.start();
            end = ((String)head).toLowerCase().indexOf("</script>", start);
            if (end <= 0) continue;
            script = (String)script + ((String)head).substring(start, end + 9) + "\n";
        }
        return script;
    }

    protected String __handleHead(String content) {
        if (content == null) {
            return "";
        }
        String head = "";
        try {
            Pattern p = Pattern.compile("<\\s*head[^\\>]*\\>", 2);
            Matcher m = p.matcher(content);
            if (m.find()) {
                int start = m.end();
                int end = content.toLowerCase().indexOf("</head>");
                head = content.substring(start + 1, end);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return head;
    }

    protected String __handleBody(String content) {
        String body = content;
        if (content == null) {
            return "";
        }
        try {
            Pattern p = Pattern.compile("<\\s*body[^\\>]*\\>", 2);
            Matcher m = p.matcher(content);
            if (m.find()) {
                int start = m.end();
                int end = content.toLowerCase().indexOf("</body>");
                body = content.substring(start + 1, end);
            }
        }
        catch (Exception e) {
            body = content;
        }
        body = body.replaceAll("class=\"style", "class=\"style" + this.viewer.getId());
        return body;
    }

    protected void __handleOutputReport(OutputStream out, IViewingSession session) throws Exception {
        if (this.viewer.isDocumentInUrl()) {
            this.__renderDocument(out);
        } else {
            this.__renderReport(out, session);
        }
    }

    private void __renderDocument(OutputStream out) throws Exception {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String documentFile = ParameterAccessor.getReportDocument(request, this.viewer.getReportDocument(), false);
        try (IReportDocument doc = ReportEngineService.getInstance().openReportDocument(null, documentFile, BirtTagUtil.getModuleOptions(this.viewer));){
            String realReportletId = this.viewer.getReportletId();
            if (realReportletId == null && this.viewer.getBookmark() != null && "true".equalsIgnoreCase(this.viewer.getIsReportlet())) {
                realReportletId = this.viewer.getBookmark();
            }
            if (realReportletId != null) {
                ReportEngineService.getInstance().renderReportlet(out, doc, this.options, realReportletId, null);
            } else {
                ReportEngineService.getInstance().renderReport(out, doc, this.viewer.getPageNum(), this.viewer.getPageRange(), this.options, null);
            }
        }
    }

    private void __renderReport(OutputStream out, IViewingSession session) throws Exception {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        IReportRunnable runnable = (IReportRunnable)this.reportDesignHandle.getDesignObject();
        String reportTitle = ParameterAccessor.htmlDecode(BirtUtility.getTitleFromDesign(this.reportDesignHandle));
        Map params = this.__handleParameters(this.reportDesignHandle, null);
        Collection parameterDefList = this.getReportService().getParameterDefinitions(this.reportDesignHandle, this.options, false);
        Map displayTexts = BirtUtility.getDisplayTexts(parameterDefList, null, (HttpServletRequest)this.pageContext.getRequest());
        String realReportletId = this.viewer.getReportletId();
        if (realReportletId == null && this.viewer.getBookmark() != null && "true".equalsIgnoreCase(this.viewer.getIsReportlet())) {
            realReportletId = this.viewer.getBookmark();
        }
        if (realReportletId != null) {
            Locale locale = (Locale)this.options.getOption("locale");
            TimeZone timeZone = (TimeZone)this.options.getOption("timeZone");
            String documentName = session.getCachedReportDocument(this.viewer.getReportDesign(), this.viewer.getId());
            List<Exception> errors = ReportEngineService.getInstance().runReport(request, runnable, documentName, locale, timeZone, params, displayTexts, this.viewer.getMaxRowsOfRecords());
            if (errors != null && !errors.isEmpty()) {
                Iterator<Exception> i = errors.iterator();
                while (i.hasNext()) {
                    i.next().printStackTrace();
                }
            }
            IReportDocument doc = ReportEngineService.getInstance().openReportDocument(null, documentName, BirtTagUtil.getModuleOptions(this.viewer));
            ReportEngineService.getInstance().renderReportlet(out, doc, this.options, realReportletId, null);
        } else {
            ReportEngineService.getInstance().runAndRenderReport(runnable, out, this.options, params, Boolean.TRUE, null, null, displayTexts, reportTitle, this.viewer.getMaxRowsOfRecords());
        }
    }

    protected Map __handleParameters(IViewerReportDesignHandle reportDesignHandle, Map params) throws Exception {
        List parameterList;
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if ((parameterList = BirtUtility.getParameterList(reportDesignHandle)) == null) {
            return params;
        }
        Map paramMap = this.viewer.getParameters();
        for (Object handle : parameterList) {
            Object paramObj;
            if (!(handle instanceof ScalarParameterHandle)) continue;
            ScalarParameterHandle parameterHandle = (ScalarParameterHandle)handle;
            boolean isMultiValue = "multi-value".equalsIgnoreCase(parameterHandle.getParamType());
            String paramName = parameterHandle.getName();
            ParameterField field = (ParameterField)paramMap.get(paramName);
            if (field != null) {
                paramObj = field.getValue();
                if (paramObj == null) {
                    params.put(paramName, null);
                    continue;
                }
                if (!(paramObj instanceof String)) {
                    if (isMultiValue) {
                        Object[] values = paramObj instanceof Object[] ? (Object[])paramObj : new Object[]{paramObj};
                        int i = 0;
                        while (i < values.length) {
                            if (values[i] instanceof String) {
                                values[i] = this.getParameterValue(parameterHandle, field, (String)values[i]);
                            }
                            ++i;
                        }
                        params.put(paramName, values);
                        continue;
                    }
                    params.put(paramName, paramObj);
                    continue;
                }
                Object paramValue = this.getParameterValue(parameterHandle, field, (String)paramObj);
                if (isMultiValue) {
                    params.put(paramName, new Object[]{paramValue});
                    continue;
                }
                params.put(paramName, paramValue);
                continue;
            }
            paramObj = this.getReportService().getParameterDefaultValue(reportDesignHandle, paramName, this.options);
            params.put(paramName, paramObj);
        }
        return params;
    }

    private Object getParameterValue(ScalarParameterHandle handle, ParameterField field, String value) throws Exception {
        String dataType = handle.getDataType();
        if ("string".equalsIgnoreCase(dataType)) {
            return value;
        }
        String pattern = field.getPattern();
        if (pattern == null || pattern.length() <= 0) {
            pattern = handle.getPattern();
        }
        return DataUtil.validate(handle.getName(), handle.getDataType(), pattern, value, this.locale, this.timeZone, field.isLocale());
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    public void setReportContainer(String reportContainer) {
        this.viewer.setReportContainer(reportContainer);
    }
}

