/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.validators.IValidatorProvider;
import org.eclipse.birt.report.model.validators.ValidationNode;

public abstract class ActivityRecord
implements IActivityRecord,
IValidatorProvider {
    public static final int INITIAL_STATE = 0;
    public static final int DONE_STATE = 1;
    public static final int UNDONE_STATE = 2;
    public static final int REDONE_STATE = 3;
    public static final int DISCARD_STATE = 4;
    protected int state = 0;
    protected Object sender = null;
    protected String label;
    private int transNo = 0;
    protected boolean isPersistent = false;

    public void destroy() {
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String text) {
        this.label = text;
    }

    @Override
    public abstract void execute();

    @Override
    public abstract void undo();

    @Override
    public abstract void redo();

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        assert (this.state == 0 && newState == 1 || this.state == 1 && newState == 2 || this.state == 2 && newState == 3 || this.state == 3 && newState == 2 || newState == 4);
        this.state = newState;
    }

    public Object getSender() {
        return this.sender;
    }

    public void setSender(Object obj) {
        this.sender = obj;
    }

    public void setTransNo(int n) {
        this.transNo = n;
    }

    public int getTransNo() {
        return this.transNo;
    }

    @Override
    public List<ValidationNode> getValidators() {
        return Collections.emptyList();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public abstract void rollback();

    protected List<RecordTask> getPostTasks() {
        return Collections.emptyList();
    }

    protected void performPostTasks(Stack<CompoundRecord> transStack) {
        List<RecordTask> tasks = this.getPostTasks();
        int i = 0;
        while (i < tasks.size()) {
            RecordTask subTask = tasks.get(i);
            subTask.doTask(this, transStack);
            ++i;
        }
    }
}

