/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.osgi.util.BundleClassLoaderHelperFactory;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiClassLoader.class);
    private Bundle _bundle;
    private ClassLoader _osgiBundleClassLoader;
    private ClassLoader _parent = this.getParent();

    public OSGiClassLoader(ClassLoader parent, Bundle bundle) {
        super(new URL[0], parent);
        this._bundle = bundle;
        this._osgiBundleClassLoader = BundleClassLoaderHelperFactory.getFactory().getHelper().getBundleClassLoader(this._bundle);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean triedParent = false;
        if (url == null && (url = this._osgiBundleClassLoader.getResource(name)) == null && name.startsWith("/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HACK leading / off {}", (Object)name);
            }
            url = this._osgiBundleClassLoader.getResource(name.substring(1));
        }
        if (url == null && !triedParent && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && LOG.isDebugEnabled()) {
            LOG.debug("getResource({})={}", (Object)name, (Object)url);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            ClassNotFoundException ex = null;
            boolean triedParent = false;
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    ex = e;
                }
            }
            if (c == null && this._parent != null && !triedParent) {
                c = this._parent.loadClass(name);
            }
            if (c == null) {
                throw ex;
            }
            if (resolve) {
                this.resolveClass(c);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded {} from {}", c, (Object)c.getClassLoader());
            }
            return c;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> osgiUrls = this._osgiBundleClassLoader.getResources(name);
        Enumeration<URL> urls = super.getResources(name);
        return Collections.enumeration(this.toList(osgiUrls, urls));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this._osgiBundleClassLoader.loadClass(name);
    }

    private List<URL> toList(Enumeration<URL> e, Enumeration<URL> e2) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (e != null && e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        while (e2 != null && e2.hasMoreElements()) {
            list.add(e2.nextElement());
        }
        return list;
    }
}

