/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.schema.impl;

import java.util.Collection;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.constraints.Assertion;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterSet;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.BuiltInFunction;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class SchemaImpl
extends SQLObjectImpl
implements Schema {
    protected EList triggers;
    protected EList indices;
    protected EList tables;
    protected EList sequences;
    protected Database database;
    protected Catalog catalog;
    protected EList assertions;
    protected EList userDefinedTypes;
    protected EList charSets;
    protected EList routines;
    protected AuthorizationIdentifier owner;

    protected SchemaImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SQLSchemaPackage.Literals.SCHEMA;
    }

    @Override
    public EList getTriggers() {
        if (this.triggers == null) {
            this.triggers = new EObjectWithInverseResolvingEList(Trigger.class, (InternalEObject)this, 8, 8);
        }
        return this.triggers;
    }

    @Override
    public EList getIndices() {
        if (this.indices == null) {
            this.indices = new EObjectWithInverseResolvingEList(Index.class, (InternalEObject)this, 9, 8);
        }
        return this.indices;
    }

    @Override
    public EList getTables() {
        if (this.tables == null) {
            this.tables = new EObjectWithInverseResolvingEList(Table.class, (InternalEObject)this, 10, 11);
        }
        return this.tables;
    }

    @Override
    public EList getSequences() {
        if (this.sequences == null) {
            this.sequences = new EObjectWithInverseResolvingEList(Sequence.class, (InternalEObject)this, 11, 11);
        }
        return this.sequences;
    }

    @Override
    public Database getDatabase() {
        if (this.database != null && this.database.eIsProxy()) {
            InternalEObject oldDatabase = (InternalEObject)this.database;
            this.database = (Database)this.eResolveProxy(oldDatabase);
            if (this.database != oldDatabase && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldDatabase, (Object)this.database));
            }
        }
        return this.database;
    }

    public Database basicGetDatabase() {
        return this.database;
    }

    public NotificationChain basicSetDatabase(Database newDatabase, NotificationChain msgs) {
        Database oldDatabase = this.database;
        this.database = newDatabase;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldDatabase, (Object)newDatabase);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setDatabase(Database newDatabase) {
        if (newDatabase != this.database) {
            NotificationChain msgs = null;
            if (this.database != null) {
                msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 10, Database.class, msgs);
            }
            if (newDatabase != null) {
                msgs = ((InternalEObject)newDatabase).eInverseAdd((InternalEObject)this, 10, Database.class, msgs);
            }
            if ((msgs = this.basicSetDatabase(newDatabase, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newDatabase, (Object)newDatabase));
        }
    }

    @Override
    public Catalog getCatalog() {
        if (this.catalog != null && this.catalog.eIsProxy()) {
            InternalEObject oldCatalog = (InternalEObject)this.catalog;
            this.catalog = (Catalog)this.eResolveProxy(oldCatalog);
            if (this.catalog != oldCatalog && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldCatalog, (Object)this.catalog));
            }
        }
        return this.catalog;
    }

    public Catalog basicGetCatalog() {
        return this.catalog;
    }

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        Catalog oldCatalog = this.catalog;
        this.catalog = newCatalog;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldCatalog, (Object)newCatalog);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCatalog(Catalog newCatalog) {
        if (newCatalog != this.catalog) {
            NotificationChain msgs = null;
            if (this.catalog != null) {
                msgs = ((InternalEObject)this.catalog).eInverseRemove((InternalEObject)this, 9, Catalog.class, msgs);
            }
            if (newCatalog != null) {
                msgs = ((InternalEObject)newCatalog).eInverseAdd((InternalEObject)this, 9, Catalog.class, msgs);
            }
            if ((msgs = this.basicSetCatalog(newCatalog, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newCatalog, (Object)newCatalog));
        }
    }

    @Override
    public EList getAssertions() {
        if (this.assertions == null) {
            this.assertions = new EObjectWithInverseResolvingEList(Assertion.class, (InternalEObject)this, 14, 12);
        }
        return this.assertions;
    }

    @Override
    public EList getUserDefinedTypes() {
        if (this.userDefinedTypes == null) {
            this.userDefinedTypes = new EObjectWithInverseResolvingEList(UserDefinedType.class, (InternalEObject)this, 15, 8);
        }
        return this.userDefinedTypes;
    }

    @Override
    public EList getCharSets() {
        if (this.charSets == null) {
            this.charSets = new EObjectWithInverseResolvingEList(CharacterSet.class, (InternalEObject)this, 16, 12);
        }
        return this.charSets;
    }

    @Override
    public EList getRoutines() {
        if (this.routines == null) {
            this.routines = new EObjectWithInverseResolvingEList(Routine.class, (InternalEObject)this, 17, 20);
        }
        return this.routines;
    }

    @Override
    public EList getProcedures() {
        return this.getSpecializedRoutines(Procedure.class);
    }

    @Override
    public EList getUDFs() {
        return this.getSpecializedRoutines(UserDefinedFunction.class);
    }

    @Override
    public EList getBuiltInFunctions() {
        return this.getSpecializedRoutines(BuiltInFunction.class);
    }

    protected EList getSpecializedRoutines(Class aDesiredClass) {
        BasicEList specializedRoutines = new BasicEList();
        EList routines = this.getRoutines();
        int i = 0;
        int routineCnt = routines.size();
        while (i < routineCnt) {
            Object obj = routines.get(i);
            if (aDesiredClass.isAssignableFrom(obj.getClass())) {
                specializedRoutines.add(obj);
            }
            ++i;
        }
        return specializedRoutines;
    }

    @Override
    public AuthorizationIdentifier getOwner() {
        if (this.owner != null && this.owner.eIsProxy()) {
            InternalEObject oldOwner = (InternalEObject)this.owner;
            this.owner = (AuthorizationIdentifier)this.eResolveProxy(oldOwner);
            if (this.owner != oldOwner && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 18, (Object)oldOwner, (Object)this.owner));
            }
        }
        return this.owner;
    }

    public AuthorizationIdentifier basicGetOwner() {
        return this.owner;
    }

    public NotificationChain basicSetOwner(AuthorizationIdentifier newOwner, NotificationChain msgs) {
        AuthorizationIdentifier oldOwner = this.owner;
        this.owner = newOwner;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldOwner, (Object)newOwner);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setOwner(AuthorizationIdentifier newOwner) {
        if (newOwner != this.owner) {
            NotificationChain msgs = null;
            if (this.owner != null) {
                msgs = ((InternalEObject)this.owner).eInverseRemove((InternalEObject)this, 8, AuthorizationIdentifier.class, msgs);
            }
            if (newOwner != null) {
                msgs = ((InternalEObject)newOwner).eInverseAdd((InternalEObject)this, 8, AuthorizationIdentifier.class, msgs);
            }
            if ((msgs = this.basicSetOwner(newOwner, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)newOwner, (Object)newOwner));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getTriggers()).basicAdd((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getIndices()).basicAdd((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getTables()).basicAdd((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getSequences()).basicAdd((Object)otherEnd, msgs);
            }
            case 12: {
                if (this.database != null) {
                    msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 10, Database.class, msgs);
                }
                return this.basicSetDatabase((Database)otherEnd, msgs);
            }
            case 13: {
                if (this.catalog != null) {
                    msgs = ((InternalEObject)this.catalog).eInverseRemove((InternalEObject)this, 9, Catalog.class, msgs);
                }
                return this.basicSetCatalog((Catalog)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getAssertions()).basicAdd((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getUserDefinedTypes()).basicAdd((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getCharSets()).basicAdd((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getRoutines()).basicAdd((Object)otherEnd, msgs);
            }
            case 18: {
                if (this.owner != null) {
                    msgs = ((InternalEObject)this.owner).eInverseRemove((InternalEObject)this, 8, AuthorizationIdentifier.class, msgs);
                }
                return this.basicSetOwner((AuthorizationIdentifier)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getTriggers()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getIndices()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getTables()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getSequences()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return this.basicSetDatabase(null, msgs);
            }
            case 13: {
                return this.basicSetCatalog(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getAssertions()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getUserDefinedTypes()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return ((InternalEList)this.getCharSets()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getRoutines()).basicRemove((Object)otherEnd, msgs);
            }
            case 18: {
                return this.basicSetOwner(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getTriggers();
            }
            case 9: {
                return this.getIndices();
            }
            case 10: {
                return this.getTables();
            }
            case 11: {
                return this.getSequences();
            }
            case 12: {
                if (resolve) {
                    return this.getDatabase();
                }
                return this.basicGetDatabase();
            }
            case 13: {
                if (resolve) {
                    return this.getCatalog();
                }
                return this.basicGetCatalog();
            }
            case 14: {
                return this.getAssertions();
            }
            case 15: {
                return this.getUserDefinedTypes();
            }
            case 16: {
                return this.getCharSets();
            }
            case 17: {
                return this.getRoutines();
            }
            case 18: {
                if (resolve) {
                    return this.getOwner();
                }
                return this.basicGetOwner();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getTriggers().clear();
                this.getTriggers().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getIndices().clear();
                this.getIndices().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getTables().clear();
                this.getTables().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getSequences().clear();
                this.getSequences().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setDatabase((Database)newValue);
                return;
            }
            case 13: {
                this.setCatalog((Catalog)newValue);
                return;
            }
            case 14: {
                this.getAssertions().clear();
                this.getAssertions().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getUserDefinedTypes().clear();
                this.getUserDefinedTypes().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getCharSets().clear();
                this.getCharSets().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getRoutines().clear();
                this.getRoutines().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setOwner((AuthorizationIdentifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getTriggers().clear();
                return;
            }
            case 9: {
                this.getIndices().clear();
                return;
            }
            case 10: {
                this.getTables().clear();
                return;
            }
            case 11: {
                this.getSequences().clear();
                return;
            }
            case 12: {
                this.setDatabase(null);
                return;
            }
            case 13: {
                this.setCatalog(null);
                return;
            }
            case 14: {
                this.getAssertions().clear();
                return;
            }
            case 15: {
                this.getUserDefinedTypes().clear();
                return;
            }
            case 16: {
                this.getCharSets().clear();
                return;
            }
            case 17: {
                this.getRoutines().clear();
                return;
            }
            case 18: {
                this.setOwner(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.triggers != null && !this.triggers.isEmpty();
            }
            case 9: {
                return this.indices != null && !this.indices.isEmpty();
            }
            case 10: {
                return this.tables != null && !this.tables.isEmpty();
            }
            case 11: {
                return this.sequences != null && !this.sequences.isEmpty();
            }
            case 12: {
                return this.database != null;
            }
            case 13: {
                return this.catalog != null;
            }
            case 14: {
                return this.assertions != null && !this.assertions.isEmpty();
            }
            case 15: {
                return this.userDefinedTypes != null && !this.userDefinedTypes.isEmpty();
            }
            case 16: {
                return this.charSets != null && !this.charSets.isEmpty();
            }
            case 17: {
                return this.routines != null && !this.routines.isEmpty();
            }
            case 18: {
                return this.owner != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

