/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IBookmarkInfo;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentHelper;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class DocumentUtil {
    public static void copy(IArchiveFile source, IArchiveFile target, IReportRunnable runnable) throws EngineException {
        DocumentUtil.copy(source, target, runnable, null);
    }

    public static void copy(IArchiveFile source, IArchiveFile target, IReportRunnable runnable, Map<String, String> transformations) throws EngineException {
        try {
            ArchiveUtil.copy(source, target, transformations);
        }
        catch (IOException ex) {
            throw new EngineException("Error.ExceptionOnCopyingArchives", ex);
        }
        if (runnable != null) {
            IDocumentWriter writer = runnable.getReportEngine().openDocumentWriter(target);
            writer.setRunnable(runnable);
            writer.close();
        }
    }

    public static Collection<IBookmarkInfo> getBookmarks(IReportDocument document, Locale locale) throws EngineException {
        if (document instanceof IReportDocumentHelper) {
            IReportDocumentHelper helper = (IReportDocumentHelper)((Object)document);
            return helper.getBookmarkInfos(locale);
        }
        return null;
    }

    public static boolean isCube(IReportDocument document, InstanceID instanceId) {
        assert (document != null);
        assert (instanceId != null);
        ReportDesignHandle report = document.getReportDesign();
        InstanceID iid = instanceId;
        while (iid != null) {
            long id = iid.getComponentID();
            DesignElementHandle handle = report.getElementByID(id);
            if (handle instanceof ReportItemHandle) {
                ReportItemHandle rhandle = (ReportItemHandle)handle;
                DataSetHandle dsHandle = rhandle.getDataSet();
                CubeHandle cbHandle = rhandle.getCube();
                if (dsHandle != null) {
                    return false;
                }
                if (cbHandle != null) {
                    return true;
                }
            }
            iid = iid.getParentID();
        }
        return false;
    }
}

