/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ChartDynamicExtension {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/trace");
    protected static final List<EPackage> extendedPackages;
    protected static final Set<EClass> extendedEClasses;

    static {
        ChartDynamicExtension.registerExtendedChartPackages();
        extendedPackages = Collections.unmodifiableList(ChartDynamicExtension.findExtendedPackages());
        extendedEClasses = ChartDynamicExtension.getEClasses(extendedPackages);
    }

    private static List<EPackage> findExtendedPackages() {
        ArrayList<EPackage> pkgs = new ArrayList<EPackage>();
        try {
            for (Map.Entry<String, Object> e : PluginSettings.instance().getExtChartModelPackages().entrySet()) {
                pkgs.add((EPackage)e.getValue());
            }
        }
        catch (ChartException e) {
            logger.log(e);
        }
        return pkgs;
    }

    public static boolean isExtended(EObject eObj) {
        return eObj != null && extendedEClasses.contains(eObj.eClass());
    }

    private static Set<EClass> getEClasses(List<EPackage> packages) {
        HashSet<EClass> set = new HashSet<EClass>();
        for (EPackage pkg : packages) {
            for (EClassifier eClassifier : pkg.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                set.add((EClass)eClassifier);
            }
        }
        return set;
    }

    private static void registerExtendedChartPackages() {
        try {
            for (Map.Entry<String, Object> e : PluginSettings.instance().getExtChartModelPackages().entrySet()) {
                EPackage.Registry.INSTANCE.put((Object)e.getKey(), e.getValue());
            }
        }
        catch (ChartException e) {
            logger.log(e);
        }
    }
}

