/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.PercentileAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalQuartile
extends AggrFunction {
    @Override
    public String getName() {
        return "QUARTILE";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("quart", Messages.getString("TotalQuartile.param.quart"), false, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalQuartile.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalQuartile.displayName");
    }

    private static class MyAccumulator
    extends PercentileAccumulator {
        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        protected double getPctValue(Double d) throws DataException {
            this.validatePctValue(d);
            int quar = d.intValue();
            double result = 0.0;
            if (quar == 0) {
                result = 0.0;
            } else if (quar == 1) {
                result = 0.25;
            } else if (quar == 2) {
                result = 0.5;
            } else if (quar == 3) {
                result = 0.75;
            } else if (quar == 4) {
                result = 1.0;
            }
            return result;
        }

        private void validatePctValue(Double d) throws DataException {
            if (d == null || d.isNaN() || d < 0.0 || d > 4.0) {
                throw DataException.wrap(new AggrException("aggregation.InvalidQuartileArgument"));
            }
        }
    }
}

