/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITableGroupEventHandler;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.TableGroup;
import org.eclipse.birt.report.engine.script.internal.instance.ReportElementInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.TableGroupHandle;

public class TableGroupScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TableGroupHandle groupHandle, ExecutionContext context) {
        try {
            TableGroup group = new TableGroup(groupHandle);
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(groupHandle, context);
            if (eh != null) {
                eh.onPrepare(group, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ITableGroupContent content, ExecutionContext context) {
        ReportItemDesign tableGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableGroupScriptExecutor.needOnCreate(tableGroupDesign)) {
            return;
        }
        try {
            ReportElementInstance table = new ReportElementInstance(content, context, RunningState.CREATE);
            if (TableGroupScriptExecutor.handleScript(table, tableGroupDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(tableGroupDesign, context);
            if (eh != null) {
                eh.onCreate(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e, tableGroupDesign.getHandle());
        }
    }

    public static void handleOnRender(ITableGroupContent content, ExecutionContext context) {
        ReportItemDesign tableGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableGroupScriptExecutor.needOnRender(tableGroupDesign)) {
            return;
        }
        try {
            ReportElementInstance table = new ReportElementInstance(content, context, RunningState.RENDER);
            if (TableGroupScriptExecutor.handleScript(table, tableGroupDesign.getOnRender(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(tableGroupDesign, context);
            if (eh != null) {
                eh.onRender(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e, tableGroupDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(ITableGroupContent content, ExecutionContext context) {
        ReportItemDesign tableGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableGroupScriptExecutor.needOnPageBreak(tableGroupDesign, context)) {
            return;
        }
        try {
            ReportElementInstance table = new ReportElementInstance(content, context, RunningState.PAGEBREAK);
            if (TableGroupScriptExecutor.handleScript(table, tableGroupDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITableGroupEventHandler eh = TableGroupScriptExecutor.getEventHandler(tableGroupDesign, context);
            if (eh != null) {
                eh.onPageBreak(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableGroupScriptExecutor.addException(context, e, tableGroupDesign.getHandle());
        }
    }

    private static ITableGroupEventHandler getEventHandler(TableGroupHandle handle, ExecutionContext context) {
        try {
            return (ITableGroupEventHandler)TableGroupScriptExecutor.getInstance(handle, context);
        }
        catch (ClassCastException e) {
            TableGroupScriptExecutor.addClassCastException(context, e, handle, ITableGroupEventHandler.class);
        }
        catch (EngineException e) {
            TableGroupScriptExecutor.addException(context, e, handle);
        }
        return null;
    }

    private static ITableGroupEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ITableGroupEventHandler)TableGroupScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            TableGroupScriptExecutor.addClassCastException(context, e, design.getHandle(), ITableGroupEventHandler.class);
        }
        catch (EngineException e) {
            TableGroupScriptExecutor.addException(context, e, design.getHandle());
        }
        return null;
    }
}

