/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.util;

import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CrosstabExtendedItemFactory
implements ICrosstabConstants {
    public static ExtendedItemHandle createCrosstabReportItem(ModuleHandle module, CubeHandle cube, String name) throws SemanticException {
        if (module == null) {
            return null;
        }
        ExtendedItemHandle extendedItem = module.getElementFactory().newExtendedItem(name, "Crosstab");
        if (extendedItem != null) {
            extendedItem.setExtensionVersion("3.7.0");
            extendedItem.setProperty("cube", cube);
            ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(module);
            if (cellHandle != null) {
                extendedItem.getPropertyHandle("header").add(cellHandle);
            }
        }
        return extendedItem;
    }

    public static ExtendedItemHandle createCrosstabView(ModuleHandle module) {
        if (module == null) {
            return null;
        }
        return module.getElementFactory().newExtendedItem(null, "CrosstabView");
    }

    public static ExtendedItemHandle createDimensionView(ModuleHandle module, DimensionHandle dimension) throws SemanticException {
        if (module == null) {
            return null;
        }
        ExtendedItemHandle extendedItem = module.getElementFactory().newExtendedItem(null, "DimensionView");
        if (extendedItem != null) {
            extendedItem.setProperty("dimension", dimension);
        }
        return extendedItem;
    }

    public static ExtendedItemHandle createMeasureView(ModuleHandle module, MeasureHandle measure) throws SemanticException {
        if (module == null) {
            return null;
        }
        ExtendedItemHandle extendedItem = module.getElementFactory().newExtendedItem(null, "MeasureView");
        if (extendedItem == null) {
            return null;
        }
        extendedItem.setProperty("measure", measure);
        ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createAggregationCell(module);
        if (cellHandle != null) {
            extendedItem.getPropertyHandle("detail").add(cellHandle);
        }
        return extendedItem;
    }

    public static ExtendedItemHandle createComputedMeasureView(ModuleHandle module, String measureViewName) throws SemanticException {
        if (module == null) {
            return null;
        }
        ExtendedItemHandle extendedItem = module.getElementFactory().newExtendedItem(measureViewName, "ComputedMeasureView");
        if (extendedItem == null) {
            return null;
        }
        ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createAggregationCell(module);
        if (cellHandle != null) {
            extendedItem.getPropertyHandle("detail").add(cellHandle);
        }
        return extendedItem;
    }

    public static ExtendedItemHandle createLevelView(ModuleHandle module, LevelHandle level) throws SemanticException {
        if (module == null) {
            return null;
        }
        ExtendedItemHandle extendedItem = module.getElementFactory().newExtendedItem(null, "LevelView");
        if (extendedItem == null) {
            return null;
        }
        extendedItem.setProperty("level", level);
        ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(module);
        if (cellHandle != null) {
            extendedItem.getPropertyHandle("member").add(cellHandle);
        }
        return extendedItem;
    }

    public static ExtendedItemHandle createCrosstabCell(ModuleHandle module) {
        if (module == null) {
            return null;
        }
        return module.getElementFactory().newExtendedItem(null, "CrosstabCell");
    }

    public static ExtendedItemHandle createAggregationCell(ModuleHandle module) {
        if (module == null) {
            return null;
        }
        return module.getElementFactory().newExtendedItem(null, "AggregationCell");
    }
}

