/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.commands.CmdBaseTestCase;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.model.api.SlotHandle;

public class DeleteCommandTest
extends CmdBaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createFirstRow();
        this.createSecondRow();
        this.createFirstCell();
        this.createSecondCell();
    }

    public void testDeleteEmptyCell() {
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.firstCell);
        DeleteCommandTest.assertFalse((boolean)deleteCmd.canExecute());
    }

    public void testDeleteCell() {
        this.addDataItems();
        DeleteCommandTest.assertEquals((int)1, (int)this.firstCell.getContent().getCount());
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.firstCell);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertEquals((int)0, (int)this.firstCell.getContent().getCount());
    }

    public void testDeleteFirstRow() {
        DeleteCommandTest.assertEquals((int)2, (int)this.table.getDetail().getCount());
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.firstRow);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertEquals((int)1, (int)this.table.getDetail().getCount());
        DeleteCommandTest.assertEquals((Object)this.secondRow, (Object)this.table.getDetail().get(0));
    }

    public void testDeleteSecondRow() {
        DeleteCommandTest.assertEquals((int)2, (int)this.table.getDetail().getCount());
        DeleteCommandTest.assertEquals((Object)this.firstRow, (Object)this.table.getDetail().get(1));
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.secondRow);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertEquals((int)1, (int)this.table.getDetail().getCount());
        DeleteCommandTest.assertEquals((Object)this.firstRow, (Object)this.table.getDetail().get(0));
    }

    public void testDeleteColumn() {
        this.createColumn();
        DeleteCommandTest.assertEquals((int)2, (int)this.firstRow.getCells().getCount());
        DeleteCommandTest.assertNotNull((Object)this.adapter.getColumn(1));
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.firstColumn);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertNull((Object)this.adapter.getColumn(1));
    }

    public void testDeleteDataSet() {
        SlotHandle parent = this.getReportDesignHandle().getDataSets();
        this.createDataSet();
        DeleteCommandTest.assertEquals((int)1, (int)parent.getCount());
        DeleteCommandTest.assertEquals((Object)this.dataSet, (Object)parent.get(0));
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.dataSet);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertEquals((int)0, (int)parent.getCount());
    }

    public void testDeleteDataSource() {
        SlotHandle parent = this.getReportDesignHandle().getDataSources();
        DeleteCommandTest.assertEquals((int)0, (int)parent.getCount());
        this.createDataSource();
        this.createDataSet();
        DeleteCommandTest.assertEquals((int)1, (int)parent.getCount());
        DeleteCommandTest.assertEquals((Object)this.dataSource, (Object)parent.get(0));
        DeleteCommandTest.assertEquals((Object)this.dataSource, (Object)this.dataSet.getDataSource());
        DeleteCommand deleteCmd = new DeleteCommand((Object)this.dataSource);
        DeleteCommandTest.assertTrue((boolean)deleteCmd.canExecute());
        deleteCmd.execute();
        DeleteCommandTest.assertEquals((int)0, (int)parent.getCount());
        DeleteCommandTest.assertNull((Object)this.dataSet.getDataSource());
    }
}

