/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.impl.FunctionProvider;
import org.eclipse.birt.report.designer.internal.ui.script.PredicateWordRule;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JSPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String JS_DEFAULT = "__js_default";
    public static final String JS_COMMENT = "__js_comment";
    public static final String JS_KEYWORD = "__js_keyword";
    public static final String JS_STRING = "__js_string";
    public static final String JS_METHOD = "__js_method";
    public static final String JS_OBJECT = "__js_object";
    public static final IToken TOKEN_STRING = new Token((Object)"__js_string");
    public static final IToken TOKEN_COMMENT = new Token((Object)"__js_comment");
    public static final IToken TOKEN_DEFAULT = new Token((Object)"__js_default");
    public static final IToken TOKEN_KEYWORD = new Token((Object)"__js_keyword");
    public static final IToken TOKEN_METHOD = new Token((Object)"__js_method");
    public static final IToken TOKEN_OBJECT = new Token((Object)"__js_object");
    private static String[] keywordTokens = new String[]{"break", "case", "catch", "continue", "default", "do", "else", "for", "function", "goto", "if", "in", "new", "return", "switch", "this", "throw", "try", "var", "void", "while", "with", "const", "let", "of"};
    private static String[] constantTokens = new String[]{"false", "null", "true"};
    private ArrayList<String> globalObjectTokens = new ArrayList();
    private ArrayList<String> keywordMethods = new ArrayList();

    public JSPartitionScanner() {
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        this.fetchJSCommonObjectsMethods();
        rules.add((IPredicateRule)new MultiLineRule("/*", "*/", TOKEN_COMMENT));
        rules.add((IPredicateRule)new EndOfLineRule("//", TOKEN_COMMENT));
        rules.add((IPredicateRule)new MultiLineRule("`", "`", TOKEN_STRING));
        rules.add((IPredicateRule)new SingleLineRule("\"", "\"", TOKEN_STRING, '\\'));
        rules.add((IPredicateRule)new SingleLineRule("'", "'", TOKEN_STRING, '\\'));
        PredicateWordRule keywordRule = new PredicateWordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, TOKEN_DEFAULT);
        keywordRule.addWords(keywordTokens, TOKEN_KEYWORD);
        keywordRule.addWords(constantTokens, TOKEN_KEYWORD);
        String[] keywordArray = new String[this.keywordMethods.size()];
        keywordArray = this.keywordMethods.toArray(keywordArray);
        keywordRule.addWords(keywordArray, TOKEN_METHOD);
        String[] globalObjectArray = new String[this.globalObjectTokens.size()];
        globalObjectArray = this.globalObjectTokens.toArray(globalObjectArray);
        keywordRule.addWords(globalObjectArray, TOKEN_OBJECT);
        rules.add(keywordRule);
        this.setRuleList(rules);
    }

    private void setRuleList(List<IPredicateRule> rules) {
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    protected void addWords(WordRule rule, String[] tokens, IToken token) {
        int i = 0;
        while (i < tokens.length) {
            rule.addWord(tokens[i], token);
            ++i;
        }
    }

    private void fetchJSCommonObjectsMethods() {
        this.globalObjectTokens.add("reportContext");
        this.globalObjectTokens.add("params");
        this.globalObjectTokens.add("vars");
        this.globalObjectTokens.add("row");
        this.globalObjectTokens.add("dataSetRow");
        this.globalObjectTokens.add("measure");
        this.globalObjectTokens.add("dimension");
        this.globalObjectTokens.add("importPackage");
        this.globalObjectTokens.add("Packages");
        this.globalObjectTokens.add("_outer");
        this.keywordMethods.add("__rownum");
        this.keywordMethods.add("value");
        this.keywordMethods.add("data");
        this.keywordMethods.add("displayText");
        this.keywordMethods.add("pageNumber");
        this.keywordMethods.add("totalPage");
        try {
            List list = DEUtil.getClasses();
            for (IClassInfo classInfo : list) {
                if (!classInfo.isNative() || classInfo.getName().equals("Total")) continue;
                this.globalObjectTokens.add(classInfo.getName());
                List resultMethodList = classInfo.getMethods();
                for (IMethodInfo methodInfo : resultMethodList) {
                    this.keywordMethods.add(methodInfo.getName());
                }
                List resultMemberList = classInfo.getMembers();
                for (IMemberInfo memberInfo : resultMemberList) {
                    this.keywordMethods.add(memberInfo.getName());
                }
            }
            IScriptFunctionCategory[] classInfo = FunctionProvider.getCategories();
            int i = 0;
            while (i < classInfo.length) {
                this.globalObjectTokens.add(classInfo[i].getName());
                IScriptFunction[] methodInfo = classInfo[i].getFunctions();
                int j = 0;
                while (j < methodInfo.length) {
                    this.keywordMethods.add(methodInfo[j].getName());
                    ++j;
                }
                ++i;
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
        }
    }
}

