/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;

public class ColorHelper {
    public static final String BACKGROUND = "background";
    public static final String BOLD = "bold";
    public static final String FOREGROUND = "foreground";
    public static final String NAME = "name";
    private static final String STYLE_SEPARATOR = "|";
    private static final String NULL = "null";

    public static String getColorString(int r, int g, int b) {
        return "#" + ColorHelper.getHexString(r, 2) + ColorHelper.getHexString(g, 2) + ColorHelper.getHexString(b, 2);
    }

    private static String getHexString(int value, int minWidth) {
        Object hexString = Integer.toHexString(value);
        int i = ((String)hexString).length();
        while (i < minWidth) {
            hexString = "0" + (String)hexString;
            ++i;
        }
        return hexString;
    }

    public static String packStylePreferences(String[] stylePrefs) {
        StringBuilder styleString = new StringBuilder();
        int i = 0;
        while (i < stylePrefs.length) {
            String s = stylePrefs[i];
            if (i < 2) {
                if (s != null) {
                    styleString.append(s);
                } else {
                    styleString.append(NULL);
                }
            } else {
                styleString.append(Boolean.valueOf(s));
            }
            if (i < stylePrefs.length - 1) {
                styleString.append(" | ");
            }
            ++i;
        }
        return styleString.toString();
    }

    public static RGB toRGB(String anRGBString) {
        RGB result = null;
        if (anRGBString.length() > 6 && anRGBString.charAt(0) == '#') {
            int r = 0;
            int g = 0;
            int b = 0;
            try {
                r = Integer.parseInt(anRGBString.substring(1, 3), 16);
                g = Integer.parseInt(anRGBString.substring(3, 5), 16);
                b = Integer.parseInt(anRGBString.substring(5, 7), 16);
                result = new RGB(r, g, b);
            }
            catch (NumberFormatException e) {
                ExceptionHandler.handle(e);
            }
        }
        return result;
    }

    public static String toRGBString(RGB anRGB) {
        if (anRGB == null) {
            return "#000000";
        }
        Object red = Integer.toHexString(anRGB.red);
        while (((String)red).length() < 2) {
            red = "0" + (String)red;
        }
        Object green = Integer.toHexString(anRGB.green);
        while (((String)green).length() < 2) {
            green = "0" + (String)green;
        }
        Object blue = Integer.toHexString(anRGB.blue);
        while (((String)blue).length() < 2) {
            blue = "0" + (String)blue;
        }
        return "#" + (String)red + (String)green + (String)blue;
    }

    public static String[] unpackStylePreferences(String preference) {
        String[] stylePrefs = new String[6];
        if (preference != null) {
            String background;
            String foreground;
            StringTokenizer st = new StringTokenizer(preference, STYLE_SEPARATOR);
            stylePrefs[0] = st.hasMoreTokens() ? (foreground = st.nextToken().trim()) : NULL;
            stylePrefs[1] = st.hasMoreTokens() ? (background = st.nextToken().trim()) : NULL;
            if (st.hasMoreTokens()) {
                String bold = st.nextToken().trim();
                stylePrefs[2] = Boolean.valueOf(bold).toString();
            } else {
                stylePrefs[2] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String italic = st.nextToken().trim();
                stylePrefs[3] = Boolean.valueOf(italic).toString();
            } else {
                stylePrefs[3] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String strikethrough = st.nextToken().trim();
                stylePrefs[4] = Boolean.valueOf(strikethrough).toString();
            } else {
                stylePrefs[4] = Boolean.FALSE.toString();
            }
            if (st.hasMoreTokens()) {
                String underline = st.nextToken().trim();
                stylePrefs[5] = Boolean.valueOf(underline).toString();
            } else {
                stylePrefs[5] = Boolean.FALSE.toString();
            }
        }
        return stylePrefs;
    }

    public static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry.hasValueFor(key)) {
            return registry.getRGB(key);
        }
        return defaultRGB;
    }

    public static String findRGBString(ColorRegistry registry, String key, int r, int g, int b) {
        if (registry.hasValueFor(key)) {
            return ColorHelper.toRGBString(registry.getRGB(key));
        }
        return ColorHelper.getColorString(r, g, b);
    }
}

