/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.Connection;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileQuery;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceInputStream;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaDataHelper;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class FlatFileDataReader {
    private String currentTableName;
    private String charSet;
    private FlatFileQuery.FlatFileBufferedReader flatFileBufferedReader = null;
    private IResultSetMetaData rsmd;
    private ResultSetMetaDataHelper rsmdHelper;
    private int statementMaxRows = 0;
    private int resultSetMaxRows = 0;
    private int maxRowsToRead = 0;
    private String[] originalColumnNames;
    private boolean isFirstTimeToReadSourceData = true;
    private boolean isFirstTimeToCallReadLine = true;
    private int fetchCounter = 0;
    private int[] selectColumIndexes;
    private Connection conn;
    private List<String> nextDataLine;
    public static final int MAX_ROWS_PER_FETCH = 20000;

    public FlatFileDataReader(Connection connection, String currentTableName, int statementMaxRows, IResultSetMetaData rsmd, ResultSetMetaDataHelper rsmdHelper) throws OdaException {
        this.rsmd = rsmd;
        this.rsmdHelper = rsmdHelper;
        this.statementMaxRows = statementMaxRows;
        this.currentTableName = currentTableName;
        this.conn = connection;
        this.charSet = this.conn.getCharSet();
    }

    private void initNameIndexMap() throws OdaException {
        assert (this.originalColumnNames != null);
        HashMap<String, Integer> originalColumnNameIndexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.originalColumnNames.length) {
            originalColumnNameIndexMap.put(this.originalColumnNames[i].trim().toUpperCase(), i);
            ++i;
        }
        this.selectColumIndexes = new int[this.rsmd.getColumnCount()];
        i = 0;
        while (i < this.rsmd.getColumnCount()) {
            this.selectColumIndexes[i] = this.findIndex(this.rsmdHelper.getOriginalColumnName(this.rsmd.getColumnName(i + 1)), originalColumnNameIndexMap);
            ++i;
        }
    }

    public boolean getTrailNullColumns() {
        return this.conn.trailNullColumns();
    }

    public String[][] getSourceData() throws OdaException {
        this.createBufferedReader();
        List<String[]> v = this.fetchQueriedDataFromFileToList();
        return this.copyDataFromListToTwoDimensionArray(v);
    }

    public List<String> readLine() throws OdaException {
        if (this.isFirstTimeToCallReadLine) {
            this.createBufferedReader();
            this.isFirstTimeToCallReadLine = false;
        }
        return this.flatFileBufferedReader.readLine();
    }

    private void createBufferedReader() throws OdaException {
        try {
            if (this.flatFileBufferedReader == null) {
                this.examCharset();
                this.flatFileBufferedReader = new FlatFileQuery.FlatFileBufferedReader(this.getInputStream(), this.charSet, this.conn.getDelimeter());
            }
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    public int getMaxRowsToRead(int resultSetMaxRows) {
        this.resultSetMaxRows = resultSetMaxRows;
        this.maxRowsToRead = this.statementMaxRows != 0 && this.statementMaxRows < this.resultSetMaxRows || this.resultSetMaxRows == 0 ? this.statementMaxRows : this.resultSetMaxRows;
        return this.maxRowsToRead;
    }

    public void clearBufferedReader() {
        try {
            if (this.flatFileBufferedReader != null) {
                this.flatFileBufferedReader.close();
            }
        }
        catch (IOException iOException) {}
        this.flatFileBufferedReader = null;
    }

    public void finalize() {
        this.clearBufferedReader();
    }

    private void examCharset() throws OdaException, IOException {
        if (this.charSet != null && this.charSet.length() > 0) {
            return;
        }
        ResourceInputStream fis = this.getInputStream();
        byte[] byteMarker = new byte[2];
        ((InputStream)fis).read(byteMarker);
        this.charSet = byteMarker[0] == -1 && byteMarker[1] == -2 ? "UTF-16LE" : (byteMarker[0] == -2 && byteMarker[1] == -1 ? "UTF-16BE" : "UTF-8");
        ((InputStream)fis).close();
    }

    public int getColumnCount() throws OdaException {
        int count;
        ResourceInputStream fis = null;
        try {
            List<String> columnLine;
            this.examCharset();
            fis = this.getInputStream();
            FlatFileQuery.FlatFileBufferedReader br = new FlatFileQuery.FlatFileBufferedReader(fis, this.charSet, this.conn.getDelimeter());
            while (FlatFileDataReader.isEmptyRow(columnLine = br.readLine())) {
            }
            count = columnLine.size();
            br.close();
            fis.close();
        }
        catch (IOException iOException) {
            throw new OdaException(String.valueOf(Messages.getString("query_IO_EXCEPTION")) + fis.getLocation());
        }
        return count;
    }

    public ResourceInputStream getInputStream() throws OdaException {
        return this.conn.getInputStream(this.currentTableName);
    }

    public static boolean isEmptyRow(List<String> line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
        }
        return line.isEmpty() || line.size() == 1 && line.get(0).equals("");
    }

    private List<String[]> fetchQueriedDataFromFileToList() throws OdaException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (this.isFirstTimeToReadSourceData) {
            if (this.conn.hasColumnNames()) {
                List<String> columeNameLine;
                while (FlatFileDataReader.isEmptyRow(columeNameLine = this.flatFileBufferedReader.readLine())) {
                }
                this.originalColumnNames = this.getColumnNameArray(columeNameLine);
                this.initNameIndexMap();
            }
            if (this.conn.hasTypeLine()) {
                while (FlatFileDataReader.isEmptyRow(this.flatFileBufferedReader.readLine())) {
                }
            }
            if (!this.conn.hasColumnNames()) {
                while (FlatFileDataReader.isEmptyRow(this.nextDataLine = this.flatFileBufferedReader.readLine())) {
                }
                this.originalColumnNames = this.createTempColumnNames(this.nextDataLine);
                this.initNameIndexMap();
            } else {
                this.nextDataLine = this.flatFileBufferedReader.readLine();
            }
            this.isFirstTimeToReadSourceData = false;
        }
        int counterLimitPerFetch = this.fetchCounter + 20000;
        while ((this.maxRowsToRead <= 0 || this.fetchCounter < this.maxRowsToRead) && this.fetchCounter < counterLimitPerFetch && this.nextDataLine != null) {
            if (!FlatFileDataReader.isEmptyRow(this.nextDataLine)) {
                ++this.fetchCounter;
                result.add(this.fetchQueriedDataFromRow(this.nextDataLine));
            }
            this.nextDataLine = this.flatFileBufferedReader.readLine();
        }
        return result;
    }

    public String[] getColumnNameArray(List<String> line) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("common_CANNOT_FIND_COLUMN"));
        }
        return FlatFileDataReader.getStringArrayFromList(line);
    }

    public static String[] getStringArrayFromList(List<String> list) {
        String[] array = null;
        if (list != null) {
            array = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                array[i] = list.get(i);
                ++i;
            }
        }
        return array;
    }

    private String[][] copyDataFromListToTwoDimensionArray(List<String[]> v) throws OdaException {
        String[][] rowSet = new String[v.size()][this.rsmd.getColumnCount()];
        int i = 0;
        while (i < v.size()) {
            String[] temp = v.get(i);
            int j = 0;
            while (j < temp.length) {
                if (temp[j] != null) {
                    rowSet[i][j] = temp[j].trim();
                } else if (!this.conn.trailNullColumns()) {
                    throw new OdaException(Messages.getString("data_read_error"));
                }
                ++j;
            }
            ++i;
        }
        return rowSet;
    }

    private String[] createTempColumnNames(List<String> aRow) throws OdaException {
        String[] tempColumnNames = new String[aRow.size()];
        int i = 0;
        while (i < aRow.size()) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] fetchQueriedDataFromRow(List<String> aRow) throws OdaException {
        String[] sArray = new String[this.rsmd.getColumnCount()];
        int i = 0;
        while (i < sArray.length) {
            int location = this.selectColumIndexes[i];
            if (location != -1) {
                if (location >= aRow.size()) {
                    if (!this.conn.trailNullColumns()) throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
                    sArray[i] = null;
                } else {
                    sArray[i] = aRow.get(location).toString();
                }
            }
            ++i;
        }
        return sArray;
    }

    private int findIndex(String value, HashMap<String, Integer> originalColumnNameIndexMap) {
        Integer index = originalColumnNameIndexMap.get(value.trim().toUpperCase());
        if (index == null) {
            return -1;
        }
        return index;
    }
}

