/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import org.eclipse.birt.report.model.activity.IFilterCondition;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;

public class FilterConditionFactory {
    public static final int ELEMENT_DELETED_FILTER_CONDITION = 0;
    public static final int ELEMENT_ADDED_FILTER_CONDITION = 1;
    public static final int SAME_EVENT_FILTER_CONDITION = 2;

    public static IFilterCondition createFilterCondition(int filterConditionID) {
        switch (filterConditionID) {
            case 0: {
                return new ElementDeletedFilterCondition();
            }
            case 1: {
                return new ElementAddedFilterCondition();
            }
            case 2: {
                return new SameEventFilterCondition();
            }
        }
        return null;
    }

    static class ElementAddedFilterCondition
    implements IFilterCondition {
        ElementAddedFilterCondition() {
        }

        @Override
        public int getFilterEvent(NotificationEvent ev1, NotificationEvent ev2) {
            DesignElement target;
            ContentEvent event2;
            DesignElement container;
            if (!(ev1 instanceof ContentEvent) || ((ContentEvent)ev1).getAction() != 1) {
                return 3;
            }
            ContentEvent event1 = (ContentEvent)ev1;
            DesignElement added = (DesignElement)event1.getContent();
            if (ev2 instanceof ContentEvent ? (container = (event2 = (ContentEvent)ev2).getTarget()) == added : ev2 instanceof PropertyEvent && (target = (event2 = (PropertyEvent)ev2).getTarget()) == added) {
                return 1;
            }
            return 3;
        }
    }

    static class ElementDeletedFilterCondition
    implements IFilterCondition {
        ElementDeletedFilterCondition() {
        }

        @Override
        public int getFilterEvent(NotificationEvent ev1, NotificationEvent ev2) {
            DesignElement target;
            ContentEvent event;
            DesignElement container;
            if (!(ev1 instanceof ElementDeletedEvent)) {
                return 3;
            }
            ElementDeletedEvent event1 = (ElementDeletedEvent)ev1;
            DesignElement deleted = event1.getTarget();
            if (ev2 instanceof ContentEvent && ((ContentEvent)ev2).getAction() == 2 ? (container = (event = (ContentEvent)ev2).getTarget()) == deleted : (ev2 instanceof ElementDeletedEvent ? (event = (ElementDeletedEvent)ev2).getContainer() == deleted : ev2 instanceof PropertyEvent && (target = (event = (PropertyEvent)ev2).getTarget()) == deleted)) {
                return 1;
            }
            return 3;
        }
    }

    static class SameEventFilterCondition
    implements IFilterCondition {
        SameEventFilterCondition() {
        }

        @Override
        public int getFilterEvent(NotificationEvent ev1, NotificationEvent ev2) {
            if (ev1.isSame(ev2)) {
                return 0;
            }
            return 3;
        }
    }
}

