/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class DimensionUtil {
    private static final String ILLEGAL_UNIT = "must be one of the absolute units(CM, IN, MM, PT, PC).";
    private static final double CM_PER_INCH = 2.54;
    private static final double POINTS_PER_INCH = 72.0;
    private static final double POINTS_PER_CM = 28.346456692913385;
    private static final double POINTS_PER_PICA = 12.0;
    private static final int DEFAULT_DPI = 96;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DimensionValue convertTo(double measure, String fromUnits, String targetUnits) {
        if (targetUnits.equalsIgnoreCase(fromUnits)) {
            return new DimensionValue(measure, fromUnits);
        }
        double targetMeasure = 0.0;
        if ("in".equalsIgnoreCase(targetUnits)) {
            if ("cm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure / 2.54;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("mm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure / 2.54 / 10.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("pt".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure / 72.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else {
                if (!"pc".equalsIgnoreCase(fromUnits)) throw new IllegalArgumentException("\"fromUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
                targetMeasure = measure * 12.0 / 72.0;
            }
            return new DimensionValue(targetMeasure, targetUnits);
        } else if ("cm".equalsIgnoreCase(targetUnits)) {
            if ("in".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 2.54;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("mm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure / 10.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("pt".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure / 28.346456692913385;
                return new DimensionValue(targetMeasure, targetUnits);
            } else {
                if (!"pc".equalsIgnoreCase(fromUnits)) throw new IllegalArgumentException("\"fromUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
                targetMeasure = measure * 12.0 / 28.346456692913385;
            }
            return new DimensionValue(targetMeasure, targetUnits);
        } else if ("mm".equalsIgnoreCase(targetUnits)) {
            if ("in".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 2.54 * 10.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("cm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 10.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("pt".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 10.0 / 28.346456692913385;
                return new DimensionValue(targetMeasure, targetUnits);
            } else {
                if (!"pc".equalsIgnoreCase(fromUnits)) throw new IllegalArgumentException("\"fromUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
                targetMeasure = measure * 12.0 * 10.0 / 28.346456692913385;
            }
            return new DimensionValue(targetMeasure, targetUnits);
        } else if ("pt".equalsIgnoreCase(targetUnits)) {
            if ("in".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 72.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("cm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 28.346456692913385;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("mm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 28.346456692913385 / 10.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("pc".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 12.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else {
                if (!"px".equalsIgnoreCase(fromUnits)) throw new IllegalArgumentException("\"fromUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
                targetMeasure = measure * 72.0 / 96.0;
            }
            return new DimensionValue(targetMeasure, targetUnits);
        } else {
            if (!"pc".equalsIgnoreCase(targetUnits)) throw new IllegalArgumentException("\"targetUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
            if ("in".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 72.0 / 12.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("cm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 28.346456692913385 / 12.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else if ("mm".equalsIgnoreCase(fromUnits)) {
                targetMeasure = measure * 28.346456692913385 / 10.0 / 12.0;
                return new DimensionValue(targetMeasure, targetUnits);
            } else {
                if (!"pt".equalsIgnoreCase(fromUnits)) throw new IllegalArgumentException("\"fromUnits\"must be one of the absolute units(CM, IN, MM, PT, PC).");
                targetMeasure = measure / 12.0;
            }
        }
        return new DimensionValue(targetMeasure, targetUnits);
    }

    public static DimensionValue convertTo(DimensionValue dimension, String appUnit, String targetUnits) {
        String fromUnit = dimension.getUnits();
        if ("".equalsIgnoreCase(fromUnit)) {
            fromUnit = appUnit;
        }
        return DimensionUtil.convertTo(dimension.getMeasure(), fromUnit, targetUnits);
    }

    public static DimensionValue convertTo(String dimension, String appUnit, String targetUnits) throws PropertyValueException {
        DimensionValue dim = StringUtil.parse(dimension);
        if (dim != null) {
            return DimensionUtil.convertTo(dim, appUnit, targetUnits);
        }
        throw new PropertyValueException((Object)dimension, "Error.PropertyValueException.INVALID_VALUE", 3);
    }

    public static final boolean isAbsoluteUnit(String unit) {
        return "in".equalsIgnoreCase(unit) || "cm".equalsIgnoreCase(unit) || "mm".equalsIgnoreCase(unit) || "pt".equalsIgnoreCase(unit) || "pc".equalsIgnoreCase(unit);
    }

    public static final boolean isRelativeUnit(String unit) {
        return "em".equalsIgnoreCase(unit) || "ex".equalsIgnoreCase(unit) || "%".equalsIgnoreCase(unit) || "px".equalsIgnoreCase(unit);
    }

    public static boolean isAbsoluteFontSize(String value) {
        return "xx-small".equalsIgnoreCase(value) || "x-small".equalsIgnoreCase(value) || "small".equalsIgnoreCase(value) || "medium".equalsIgnoreCase(value) || "large".equalsIgnoreCase(value) || "x-large".equalsIgnoreCase(value) || "xx-large".equalsIgnoreCase(value);
    }

    public static boolean isRelativeFontSize(String value) {
        return "smaller".equalsIgnoreCase(value) || "larger".equalsIgnoreCase(value);
    }

    public static double convertTo(Object value, String appUnits, String targetUnits, double baseSize, int dpi) {
        return DimensionUtil.convertTo(value, appUnits, targetUnits, baseSize, "pt", dpi);
    }

    public static double convertTo(Object value, String appUnits, String targetUnits, double baseSize, String baseSizeUnits, int dpi) {
        DimensionValue parsedValue;
        if (value == null) {
            return 0.0;
        }
        double measure = 0.0;
        String fromUnits = "";
        if (value instanceof String) {
            try {
                parsedValue = StringUtil.parse((String)value);
                measure = parsedValue.getMeasure();
                fromUnits = parsedValue.getUnits();
            }
            catch (PropertyValueException e) {
                throw new IllegalArgumentException("Given string is not well-formatted dimension!");
            }
        } else if (value instanceof DimensionValue) {
            parsedValue = (DimensionValue)value;
            measure = parsedValue.getMeasure();
            fromUnits = parsedValue.getUnits();
        } else if (value instanceof DimensionHandle) {
            DimensionHandle dimensionHandle = (DimensionHandle)value;
            measure = dimensionHandle.getMeasure();
            fromUnits = dimensionHandle.getUnits();
            if (StringUtil.isBlank(fromUnits)) {
                fromUnits = dimensionHandle.getDefaultUnit();
            }
        } else {
            throw new IllegalArgumentException("Given dimension value is a not supported format!");
        }
        if (StringUtil.isBlank(fromUnits)) {
            fromUnits = appUnits;
        }
        if (StringUtil.isBlank(baseSizeUnits)) {
            baseSizeUnits = "pt";
        }
        DimensionValue convertedValue = null;
        convertedValue = "em".equals(fromUnits) ? DimensionUtil.convertTo(measure * baseSize, baseSizeUnits, targetUnits) : ("ex".equals(fromUnits) ? DimensionUtil.convertTo(measure * baseSize / 3.0, baseSizeUnits, targetUnits) : ("%".equals(fromUnits) ? DimensionUtil.convertTo(measure * baseSize / 100.0, baseSizeUnits, targetUnits) : ("px".equals(fromUnits) ? DimensionUtil.convertTo(measure / (double)dpi, "in", targetUnits) : DimensionUtil.convertTo(measure, fromUnits, targetUnits))));
        return convertedValue.getMeasure();
    }

    public static DimensionValue mergeDimension(DimensionValue dimension1, DimensionValue dimension2) {
        return DimensionUtil.mergeDimension(dimension1, dimension2, -1);
    }

    public static DimensionValue mergeDimension(DimensionValue dimension1, DimensionValue dimension2, int dpi) {
        if (dimension1 == null || dimension2 == null) {
            if (dimension1 == null) {
                return dimension2;
            }
            return dimension1;
        }
        String unit = dimension1.getUnits();
        String unit2 = dimension2.getUnits();
        Double meature = null;
        if (unit.equalsIgnoreCase(unit2)) {
            meature = dimension1.getMeasure() + dimension2.getMeasure();
        } else if (DimensionUtil.isAbsoluteUnit(unit)) {
            if (DimensionUtil.isAbsoluteUnit(unit2)) {
                meature = dimension1.getMeasure() + DimensionUtil.convertTo(dimension2, null, unit).getMeasure();
            } else if ("px".equalsIgnoreCase(unit2)) {
                meature = dimension1.getMeasure() + DimensionUtil.convertTo(dimension2, null, unit, 0.0, DimensionUtil.validateDPI(dpi));
            }
        } else if ("px".equalsIgnoreCase(unit) && DimensionUtil.isAbsoluteUnit(unit2)) {
            meature = DimensionUtil.convertTo(dimension1, null, unit2, 0.0, DimensionUtil.validateDPI(dpi)) + dimension2.getMeasure();
            unit = unit2;
        }
        if (meature != null) {
            return new DimensionValue(meature, unit);
        }
        return null;
    }

    private static int validateDPI(int dpi) {
        if (dpi <= 0) {
            dpi = 100;
        }
        if (dpi <= 0) {
            dpi = 96;
        }
        return dpi;
    }
}

