/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.gef.Request;

public class InsertAction
extends AbstractElementAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.views.action.InsertAction";
    public static final String ABOVE = "above";
    public static final String BELOW = "below";
    public static final String CURRENT = "current";
    private static final String INSERT_TEXT = Messages.getString((String)"InsertAction.text");
    private static final String NEW_MASTER_PAGE_TEXT = Messages.getString((String)"NewMasterPage.text");
    private SlotHandle slotHandle;
    private PropertyHandle propertyHandle;
    private boolean isDone;
    private Object createElement;
    private final String position;
    private String type = null;

    public PropertyHandle getPropertyHandle() {
        return this.propertyHandle;
    }

    protected SlotHandle getSlotHandle() {
        return this.slotHandle;
    }

    protected String getPosition() {
        return this.position;
    }

    protected String getType() {
        return this.type;
    }

    public InsertAction(Object selectedObject) {
        this(selectedObject, selectedObject instanceof SlotHandle && ((SlotHandle)selectedObject).getSlotID() == 4 && ((SlotHandle)selectedObject).getElementHandle() instanceof ReportDesignHandle ? NEW_MASTER_PAGE_TEXT : INSERT_TEXT);
    }

    public InsertAction(Object selectedObject, String text) {
        this(selectedObject, text, null);
    }

    public InsertAction(Object selectedObject, String text, String type) {
        this(selectedObject, text, type, CURRENT);
    }

    public InsertAction(Object selectedObject, String text, String type, String pos) {
        this(selectedObject, text, (SlotHandle)null, type, pos);
    }

    public InsertAction(Object selectedObject, String text, PropertyHandle propertyHandle, String type) {
        this(selectedObject, text, propertyHandle, type, CURRENT);
    }

    public InsertAction(Object selectedObject, String text, PropertyHandle propertyHandle, String type, String pos) {
        super(selectedObject, text);
        this.type = type;
        this.position = pos;
        this.propertyHandle = propertyHandle != null ? propertyHandle : this.getDefaultPropertyHandle();
    }

    public InsertAction(Object selectedObject, String text, SlotHandle slotHandle, String type, String pos) {
        super(selectedObject, text);
        this.type = type;
        this.position = pos;
        this.slotHandle = slotHandle != null ? slotHandle : this.getDefaultSlotHandle();
    }

    public boolean isEnabled() {
        if (this.getSelection() instanceof SlotHandle && ((SlotHandle)this.getSelection()).getSlotID() == 1 && ((SlotHandle)this.getSelection()).getElementHandle() instanceof ListingHandle) {
            return ((SlotHandle)this.getSelection()).canContain("ListGroup") || ((SlotHandle)this.getSelection()).canContain("TableGroup");
        }
        return super.isEnabled();
    }

    protected PropertyHandle getDefaultPropertyHandle() {
        String str;
        Object obj = this.getSelection();
        if (obj instanceof PropertyHandle) {
            return (PropertyHandle)obj;
        }
        ElementDetailHandle handle = (ElementDetailHandle)obj;
        if (this.position == CURRENT && (str = DEUtil.getDefaultContentName((Object)handle)) != null) {
            return handle.getElementHandle().getPropertyHandle(str);
        }
        return handle.getElementHandle().getContainerPropertyHandle();
    }

    protected SlotHandle getDefaultSlotHandle() {
        int slotId;
        Object obj = this.getSelection();
        if (obj instanceof SlotHandle) {
            return (SlotHandle)obj;
        }
        DesignElementHandle handle = (DesignElementHandle)obj;
        if (this.position == CURRENT && (slotId = DEUtil.getDefaultSlotID((Object)handle)) != -1) {
            return handle.getSlot(slotId);
        }
        return handle.getContainerSlotHandle();
    }

    @Override
    protected boolean doAction() throws Exception {
        Request request = new Request((Object)"insert");
        HashMap<String, Object> extendsData = new HashMap<String, Object>();
        extendsData.put("insert-slot", this.slotHandle);
        if (this.type != null) {
            extendsData.put("insert-type", this.type);
        }
        extendsData.put("insert-position", this.position);
        request.setExtendedData(extendsData);
        this.isDone = ProviderFactory.createProvider(this.getSelection()).performRequest(this.getSelection(), request);
        this.createElement = request.getExtendedData().get("result");
        return this.isDone;
    }

    @Override
    protected void postDoAction() {
        super.postDoAction();
        if (this.isDone && this.createElement != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.createElement);
            ReportRequest r = new ReportRequest();
            r.setType((Object)"create element");
            r.setSelectionObject(list);
            SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)r);
        }
        this.createElement = null;
    }
}

