/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx.writer;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.docx.writer.BasicComponent;
import org.eclipse.birt.report.engine.emitter.docx.writer.Footer;
import org.eclipse.birt.report.engine.emitter.docx.writer.Header;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class Document
extends BasicComponent {
    private static Logger logger = Logger.getLogger(Document.class.getName());
    private String backgroundColor;
    private String backgroundImageImgUrl;
    private String backgroundHeight;
    private String backgroundWidth;
    private int headerId = 1;
    private int footerId = 1;
    private int mhtId = 1;
    private int wordVersion;
    private String documentLanguage = "";

    Document(IPart part, String backgroundColor, String backgroundImageUrl, String backgroundHeight, String backgroundWidth, boolean rtl, int wordVersion, String documentLanguage) throws IOException {
        super(part);
        this.backgroundColor = backgroundColor;
        this.backgroundImageImgUrl = backgroundImageUrl;
        this.backgroundHeight = backgroundHeight;
        this.backgroundWidth = backgroundWidth;
        this.wordVersion = wordVersion;
        this.rtl = rtl;
        this.documentLanguage = documentLanguage;
        this.writeStylesPart();
        this.writeSettingsPart();
    }

    @Override
    void start() {
        this.writer.startWriter();
        this.writer.openTag("w:document");
        this.writeXmlns();
        this.drawDocumentBackground();
        this.writer.openTag("w:body");
    }

    private void writeStylesPart() throws IOException {
        String uri = "styles.xml";
        String type = "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles";
        IPart stylesPart = this.part.getPart(uri, type, relationshipType);
        try (OOXmlWriter stylesPartWriter = null;){
            stylesPartWriter = stylesPart.getWriter();
            stylesPartWriter.startWriter();
            stylesPartWriter.openTag("w:styles");
            stylesPartWriter.nameSpace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
            stylesPartWriter.openTag("w:docDefaults");
            stylesPartWriter.openTag("w:rPrDefault");
            stylesPartWriter.openTag("w:rPr");
            stylesPartWriter.openTag("w:rFonts");
            stylesPartWriter.attribute("w:ascii", "Times New Roman");
            stylesPartWriter.attribute("w:eastAsia", "Times New Roman");
            stylesPartWriter.attribute("w:hAnsi", "Times New Roman");
            stylesPartWriter.attribute("w:cs", "Times New Roman");
            stylesPartWriter.closeTag("w:rFonts");
            stylesPartWriter.openTag("w:lang");
            stylesPartWriter.attribute("w:val", this.documentLanguage);
            stylesPartWriter.attribute("w:eastAsia", "zh-CN");
            stylesPartWriter.attribute("w:bidi", "ar-SA");
            stylesPartWriter.closeTag("w:lang");
            stylesPartWriter.closeTag("w:rPr");
            stylesPartWriter.closeTag("w:rPrDefault");
            stylesPartWriter.openTag("w:pPrDefault");
            stylesPartWriter.closeTag("w:pPrDefault");
            stylesPartWriter.closeTag("w:docDefaults");
            stylesPartWriter.openTag("w:style");
            stylesPartWriter.attribute("w:type", "character");
            stylesPartWriter.attribute("w:styleId", "Hyperlink");
            stylesPartWriter.openTag("w:name");
            stylesPartWriter.attribute("w:val", "Hyperlink");
            stylesPartWriter.closeTag("w:name");
            stylesPartWriter.openTag("w:rPr");
            stylesPartWriter.openTag("w:u");
            stylesPartWriter.attribute("w:val", "single");
            stylesPartWriter.closeTag("w:u");
            stylesPartWriter.openTag("w:color");
            stylesPartWriter.attribute("w:val", "0000ff");
            stylesPartWriter.closeTag("w:color");
            stylesPartWriter.closeTag("w:rPr");
            stylesPartWriter.closeTag("w:style");
            stylesPartWriter.openTag("w:style");
            stylesPartWriter.attribute("w:type", "table");
            stylesPartWriter.attribute("w:default", 1);
            stylesPartWriter.attribute("w:styleId", "TableNormal");
            stylesPartWriter.openTag("w:name");
            stylesPartWriter.attribute("w:val", "Normal Table");
            stylesPartWriter.closeTag("w:name");
            stylesPartWriter.openTag("w:uiPriority");
            stylesPartWriter.attribute("w:val", 99);
            stylesPartWriter.closeTag("w:uiPriority");
            stylesPartWriter.openTag("w:semiHidden");
            stylesPartWriter.closeTag("w:semiHidden");
            stylesPartWriter.openTag("w:unhidenWhenUsed");
            stylesPartWriter.closeTag("w:unhidenWhenUsed");
            stylesPartWriter.openTag("w:qFormat");
            stylesPartWriter.closeTag("w:qFormat");
            stylesPartWriter.openTag("w:tblPr");
            stylesPartWriter.openTag("w:tblInd");
            stylesPartWriter.attribute("w:w", 0);
            stylesPartWriter.attribute("w:type", "dxa");
            stylesPartWriter.closeTag("w:tblInd");
            stylesPartWriter.openTag("w:tblCellMar");
            stylesPartWriter.openTag("w:top");
            stylesPartWriter.attribute("w:w", 0);
            stylesPartWriter.attribute("w:type", "dxa");
            stylesPartWriter.closeTag("w:top");
            stylesPartWriter.openTag("w:left");
            stylesPartWriter.attribute("w:w", 108);
            stylesPartWriter.attribute("w:type", "dxa");
            stylesPartWriter.closeTag("w:left");
            stylesPartWriter.openTag("w:bottom");
            stylesPartWriter.attribute("w:w", 0);
            stylesPartWriter.attribute("w:type", "dxa");
            stylesPartWriter.closeTag("w:bottom");
            stylesPartWriter.openTag("w:right");
            stylesPartWriter.attribute("w:w", 108);
            stylesPartWriter.attribute("w:type", "dxa");
            stylesPartWriter.closeTag("w:right");
            stylesPartWriter.closeTag("w:tblCellMar");
            stylesPartWriter.closeTag("w:tblPr");
            stylesPartWriter.closeTag("w:style");
            stylesPartWriter.closeTag("w:styles");
            stylesPartWriter.endWriter();
        }
    }

    private void writeSettingsPart() throws IOException {
        String uri = "settings.xml";
        String type = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings";
        IPart settingsPart = this.part.getPart(uri, type, relationshipType);
        try (OOXmlWriter settingsPartWriter = null;){
            settingsPartWriter = settingsPart.getWriter();
            settingsPartWriter.startWriter();
            switch (this.wordVersion) {
                case 2010: {
                    settingsPartWriter.openTag("w:settings");
                    settingsPartWriter.nameSpace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                    settingsPartWriter.nameSpace("o", "urn:schemas-microsoft-com:office:office");
                    settingsPartWriter.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                    settingsPartWriter.openTag("w:zoom");
                    settingsPartWriter.attribute("w:percent", "100");
                    settingsPartWriter.closeTag("w:zoom");
                    settingsPartWriter.openTag("w:displayBackgroundShape");
                    settingsPartWriter.closeTag("w:displayBackgroundShape");
                    settingsPartWriter.openTag("w:view");
                    settingsPartWriter.attribute("w:val", "print");
                    settingsPartWriter.closeTag("w:view");
                    settingsPartWriter.openTag("w:compat");
                    settingsPartWriter.openTag("w:compatSetting");
                    settingsPartWriter.attribute("w:name", "w:compatibilityMode");
                    settingsPartWriter.attribute("w:uri", "http://schemas.microsoft.com/office/word");
                    settingsPartWriter.attribute("w:val", "12");
                    settingsPartWriter.closeTag("w:compatSetting");
                    settingsPartWriter.closeTag("w:compat");
                    settingsPartWriter.closeTag("w:settings");
                    break;
                }
                default: {
                    settingsPartWriter.openTag("w:settings");
                    settingsPartWriter.nameSpace("mc", "http://schemas.openxmlformats.org/markup-compatibility/2006");
                    settingsPartWriter.nameSpace("o", "urn:schemas-microsoft-com:office:office");
                    settingsPartWriter.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                    settingsPartWriter.nameSpace("m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
                    settingsPartWriter.nameSpace("v", "urn:schemas-microsoft-com:vml");
                    settingsPartWriter.nameSpace("w10", "urn:schemas-microsoft-com:office:word");
                    settingsPartWriter.nameSpace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                    settingsPartWriter.nameSpace("w14", "http://schemas.microsoft.com/office/word/2010/wordml");
                    settingsPartWriter.nameSpace("w15", "http://schemas.microsoft.com/office/word/2012/wordml");
                    settingsPartWriter.nameSpace("w16cex", "http://schemas.microsoft.com/office/word/2018/wordml/cex");
                    settingsPartWriter.nameSpace("w16cid", "http://schemas.microsoft.com/office/word/2016/wordml/cid");
                    settingsPartWriter.nameSpace("w16", "http://schemas.microsoft.com/office/word/2018/wordml");
                    settingsPartWriter.nameSpace("w16se", "http://schemas.microsoft.com/office/word/2015/wordml/symex");
                    settingsPartWriter.nameSpace("sl", "http://schemas.openxmlformats.org/schemaLibrary/2006/main");
                    settingsPartWriter.attribute("mc:Ignorable", "w14 w15 w16se w16cid w16 w16cex");
                    settingsPartWriter.openTag("w:zoom");
                    settingsPartWriter.attribute("w:percent", "100");
                    settingsPartWriter.closeTag("w:zoom");
                    settingsPartWriter.openTag("w:displayBackgroundShape");
                    settingsPartWriter.closeTag("w:displayBackgroundShape");
                    settingsPartWriter.openTag("w:view");
                    settingsPartWriter.attribute("w:val", "print");
                    settingsPartWriter.closeTag("w:view");
                    settingsPartWriter.openTag("w:compat");
                    settingsPartWriter.openTag("w:compatSetting");
                    settingsPartWriter.attribute("w:name", "compatibilityMode");
                    settingsPartWriter.attribute("w:uri", "http://schemas.microsoft.com/office/word");
                    settingsPartWriter.attribute("w:val", "15");
                    settingsPartWriter.closeTag("w:compatSetting");
                    settingsPartWriter.closeTag("w:compat");
                    settingsPartWriter.closeTag("w:settings");
                }
            }
            settingsPartWriter.endWriter();
        }
    }

    @Override
    void end() {
        this.writer.closeTag("w:body");
        this.writer.closeTag("w:document");
        this.writer.endWriter();
        this.writer.close();
    }

    private void drawDocumentBackground() {
        if (this.backgroundImageImgUrl != null && this.backgroundHeight == null && this.backgroundWidth == null) {
            try {
                byte[] backgroundImageData = EmitterUtil.getImageData(this.backgroundImageImgUrl);
                ImageManager.ImagePart imagePart = this.imageManager.getImagePart(this.part, this.backgroundImageImgUrl, backgroundImageData);
                IPart part = imagePart.getPart();
                this.drawDocumentBackgroundImage(part);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            String color = WordUtil.parseColor(this.backgroundColor);
            if (color != null) {
                this.writer.openTag("w:background");
                this.writer.attribute("w:color", color);
                this.writer.closeTag("w:background");
            }
        }
    }

    private void drawDocumentBackgroundImage(IPart imagePart) {
        this.writer.openTag("w:background");
        this.writer.attribute("w:color", "FFFFFF");
        this.writer.openTag("v:background");
        this.writer.attribute("id", "");
        this.writer.openTag("v:fill");
        this.writer.attribute("r:id", imagePart.getRelationshipId());
        this.writer.attribute("recolor", "t");
        this.writer.attribute("type", "frame");
        this.writer.closeTag("v:fill");
        this.writer.closeTag("v:background");
        this.writer.closeTag("w:background");
    }

    void writeHeaderReference(BasicComponent header, boolean showHeaderOnFirst) {
        String type = showHeaderOnFirst ? "first" : "default";
        this.writer.openTag("w:headerReference");
        this.writer.attribute("w:type", type);
        this.writer.attribute("r:id", header.getRelationshipId());
        this.writer.closeTag("w:headerReference");
    }

    void writeFooterReference(BasicComponent footer) {
        this.writer.openTag("w:footerReference");
        this.writer.attribute("r:id", footer.getRelationshipId());
        this.writer.closeTag("w:footerReference");
    }

    Header createHeader(int headerHeight, int headerWidth, boolean wrapHeader) throws IOException {
        String uri = "header" + this.getHeaderID() + ".xml";
        String type = "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header";
        IPart headerPart = this.part.getPart(uri, type, relationshipType);
        return new Header(headerPart, this, headerHeight, headerWidth, wrapHeader);
    }

    Footer createFooter(int footerHeight, int footerWidth, boolean wrapHeader) throws IOException {
        String uri = "footer" + this.getFooterID() + ".xml";
        String type = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer";
        IPart footerPart = this.part.getPart(uri, type, relationshipType);
        return new Footer(footerPart, this, footerHeight, footerWidth, wrapHeader);
    }

    private int getHeaderID() {
        return this.headerId++;
    }

    private int getFooterID() {
        return this.footerId++;
    }

    @Override
    protected int getImageID() {
        return this.imageId++;
    }

    @Override
    protected int getMhtTextId() {
        return this.mhtId++;
    }

    void writePageBorders(IStyle style, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        this.writer.openTag("w:pgBorders");
        this.writer.attribute("w:offsetFrom", "page");
        this.writeBorders(style, topMargin, bottomMargin, leftMargin, rightMargin);
        this.writer.closeTag("w:pgBorders");
    }
}

