/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.PageIndexReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.SizeBasedPageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class FixedLayoutPageHintReader
implements IPageHintReader {
    protected IDocArchiveReader reader;
    protected RAInputStream indexStream;
    protected RAInputStream hintsStream;
    protected PageIndexReader pageIndexReader;
    protected long totalPage = -1L;
    protected ArrayList<PageVariable> pageVariables;
    protected int version;

    public FixedLayoutPageHintReader(IDocArchiveReader reader) throws IOException {
        this.reader = reader;
        try {
            this.hintsStream = reader.getStream("/pages");
            this.indexStream = reader.getStream("/pages_index");
            this.pageIndexReader = new PageIndexReader(reader);
            this.version = FixedLayoutPageHintReader.readHintVersion(this.hintsStream);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public static int readHintVersion(RAInputStream hintStream) throws IOException {
        hintStream.seek(0L);
        int version = hintStream.readInt();
        if (version == 0) {
            return 1;
        }
        return version;
    }

    @Override
    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
            if (this.pageIndexReader != null) {
                this.pageIndexReader.close();
                this.pageIndexReader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized long getTotalPage() throws IOException {
        this.indexStream.refresh();
        this.indexStream.seek(0L);
        this.totalPage = this.indexStream.readLong();
        return this.totalPage;
    }

    @Override
    public synchronized Collection<PageVariable> getPageVariables() throws IOException {
        if (this.pageVariables == null) {
            this.pageVariables = new ArrayList();
            if (this.version == 6) {
                this.indexStream.seek(8L);
                long offset = this.indexStream.readLong();
                if (offset != -1L) {
                    this.hintsStream.seek(offset);
                    this.readPageVariables(new DataInputStream(this.hintsStream), this.pageVariables);
                }
            }
        }
        return this.pageVariables;
    }

    private long getHintOffset(long pageNumber) {
        return (pageNumber + 1L) * 8L;
    }

    @Override
    public synchronized IPageHint getPageHint(long pageNumber) throws IOException {
        long indexOffset = this.getHintOffset(pageNumber);
        this.indexStream.seek(indexOffset);
        long offset = this.indexStream.readLong();
        this.hintsStream.seek(offset);
        return this.readPageHint(this.version, new DataInputStream(this.hintsStream));
    }

    protected IPageHint readPageHint(int version, DataInputStream in) throws IOException {
        if (version == 6) {
            return this.readFixedLayoutPageHint(in);
        }
        throw new IOException("Unsupported page hint version " + version);
    }

    public IPageHint readFixedLayoutPageHint(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong(in);
        String masterPage = IOUtil.readString(in);
        PageHint hint = new PageHint(pageNumber, masterPage);
        hint.setOffset(this.pageIndexReader.getPageOffset(masterPage));
        int sectionCount = IOUtil.readInt(in);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = null;
            int sectionType = IOUtil.readInt(in);
            section = sectionType == 1 ? new SizeBasedPageSection() : new PageSection();
            section.read(in);
            hint.addSection(section);
            ++i;
        }
        int hintSize = IOUtil.readInt(in);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = new UnresolvedRowHint();
            rowHint.readObject(new DataInputStream(in));
            hint.addUnresolvedRowHint(rowHint);
            ++i2;
        }
        int columnHintSize = IOUtil.readInt(in);
        int i3 = 0;
        while (i3 < columnHintSize) {
            String tableId = IOUtil.readString(in);
            int start = IOUtil.readInt(in);
            int columnCount = IOUtil.readInt(in);
            hint.addTableColumnHint(new TableColumnHint(tableId, start, columnCount));
            ++i3;
        }
        Collection<PageVariable> variables = hint.getPageVariables();
        this.readPageVariables(in, variables);
        return hint;
    }

    public IPageHint readPageHintV5(DataInputStream in) throws IOException {
        IPageHint hint = this.readPageHintV4(in);
        int columnHintSize = IOUtil.readInt(in);
        int i = 0;
        while (i < columnHintSize) {
            String tableId = IOUtil.readString(in);
            int start = IOUtil.readInt(in);
            int columnCount = IOUtil.readInt(in);
            hint.addTableColumnHint(new TableColumnHint(tableId, start, columnCount));
            ++i;
        }
        return hint;
    }

    public IPageHint readPageHintV4(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong(in);
        String masterPage = IOUtil.readString(in);
        PageHint hint = new PageHint(pageNumber, masterPage);
        hint.setOffset(this.pageIndexReader.getPageOffset(masterPage));
        int sectionCount = IOUtil.readInt(in);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = new PageSection();
            section.read(in);
            hint.addSection(section);
            ++i;
        }
        int hintSize = IOUtil.readInt(in);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = new UnresolvedRowHint();
            rowHint.readObject(new DataInputStream(in));
            hint.addUnresolvedRowHint(rowHint);
            ++i2;
        }
        return hint;
    }

    @Override
    public long getPageOffset(long pageNumber, String masterPage) throws IOException {
        return this.pageIndexReader.getPageOffset(masterPage);
    }

    protected void readPageVariables(DataInputStream in, Collection<PageVariable> variables) throws IOException {
        int count = IOUtil.readInt(in);
        int i = 0;
        while (i < count) {
            PageVariable variable = this.readPageVariable(in);
            variables.add(variable);
            ++i;
        }
    }

    private PageVariable readPageVariable(DataInputStream in) throws IOException {
        String name = IOUtil.readString(in);
        String scope = IOUtil.readString(in);
        Object value = IOUtil.readObject(in);
        return new PageVariable(name, scope, value);
    }
}

