/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import uk.co.spudsoft.birt.emitters.excel.Area;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractRealTableRowHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.FlattenedListHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.FlattenedTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.ITableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedListHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableHandler;

public class AbstractRealTableCellHandler
extends CellContentHandler {
    protected int column;
    private AbstractRealTableRowHandler parentRow;
    private boolean containsTable;

    public AbstractRealTableCellHandler(IContentEmitter emitter, Logger log, IHandler parent, ICellContent cell) {
        super(emitter, log, parent, cell);
        this.column = cell.getColumn();
    }

    @Override
    public void notifyHandler(HandlerState state) {
        if (this.parentRow != null) {
            this.parentRow.resumeRow(state);
            this.resumeCell(state);
            this.parentRow = null;
        }
    }

    @Override
    public void startCell(HandlerState state, ICellContent cell) throws BirtException {
        this.log.debug("Cell - BIRT[" + cell.getRow() + (String)(cell.getRowSpan() > 1 ? "-" + (cell.getRow() + cell.getRowSpan() - 1) : "") + "," + cell.getColumn() + (String)(cell.getColSpan() > 1 ? "-" + (cell.getColumn() + cell.getColSpan() - 1) : "") + "] state[" + state.rowNum + "," + state.colNum + "]");
        this.resumeCell(state);
    }

    @Override
    public void endCell(HandlerState state, ICellContent cell) throws BirtException {
        if (cell.getBookmark() != null) {
            this.createName(state, AbstractRealTableCellHandler.prepareName(cell.getBookmark()), state.rowNum, state.colNum, state.rowNum, state.colNum);
        }
        this.interruptCell(state, !this.containsTable);
    }

    public void resumeCell(HandlerState state) {
    }

    public void interruptCell(HandlerState state, boolean includeFormatOnly) throws BirtException {
        if (state == null) {
            System.err.println("state == null");
        } else if (state.currentSheet == null) {
            System.err.println("state.currentSheet == null");
        } else if (state.currentSheet.getRow(state.rowNum) == null) {
            System.err.println("state.currentSheet.getRow(" + state.rowNum + ") == null");
        }
        if (this.lastValue != null || includeFormatOnly) {
            Cell currentCell = state.currentSheet.getRow(state.rowNum).getCell(this.column);
            if (currentCell == null) {
                this.log.debug("Creating cell[", state.rowNum, ",", this.column, "]");
                currentCell = state.currentSheet.getRow(state.rowNum).createCell(this.column);
            }
            ICellContent cell = (ICellContent)this.element;
            Area area = null;
            if (cell.getColSpan() > 1 || cell.getRowSpan() > 1) {
                int endRow = state.rowNum + cell.getRowSpan() - 1;
                int endCol = state.colNum + cell.getColSpan() - 1;
                if (cell.getRowSpan() > 1) {
                    this.log.debug("Adding row span [", state.rowNum, ",", state.colNum, "] to [", endRow, ",", endCol, "]");
                    area = state.addRowSpan(state.rowNum, state.colNum, endRow, endCol);
                }
                int offset = state.computeNumberSpanBefore(state.rowNum, state.colNum);
                this.log.debug("Offset for [", state.rowNum, ",", state.colNum, "] calculated as ", offset);
                this.log.debug("Merging [", state.rowNum, ",", state.colNum + offset, "] to [", endRow, ",", endCol + offset, "]");
                this.log.debug("Should be merging ? [", state.rowNum, ",", this.column, "] to [", endRow, ",", this.column + cell.getColSpan() - 1, "]");
                CellRangeAddress newMergedRegion = new CellRangeAddress(state.rowNum, endRow, this.column, this.column + cell.getColSpan() - 1);
                Boolean newAddressRange = true;
                for (CellRangeAddress registeredMergedRegion : state.currentSheet.getMergedRegions()) {
                    if ((newMergedRegion.getFirstColumn() < registeredMergedRegion.getFirstColumn() || newMergedRegion.getFirstColumn() > registeredMergedRegion.getLastColumn() || newMergedRegion.getFirstRow() < registeredMergedRegion.getFirstRow() || newMergedRegion.getFirstRow() > registeredMergedRegion.getLastRow()) && (registeredMergedRegion.getFirstRow() != newMergedRegion.getFirstRow() || registeredMergedRegion.getFirstColumn() != newMergedRegion.getFirstColumn() || registeredMergedRegion.getLastRow() != newMergedRegion.getLastRow() || registeredMergedRegion.getLastColumn() != newMergedRegion.getLastColumn())) continue;
                    newAddressRange = false;
                    break;
                }
                if (newAddressRange.booleanValue()) {
                    state.currentSheet.addMergedRegion(newMergedRegion);
                }
                this.colSpan = cell.getColSpan();
            }
            this.endCellContent(state, cell, this.lastElement, currentCell, area);
        }
        if (state.cellIsMergedWithBorders(state.rowNum, this.column)) {
            int absoluteColumn = this.column;
            ++state.colNum;
            --this.colSpan;
            while (this.colSpan > 0) {
                this.log.debug("Creating cell[", state.rowNum, ",", ++absoluteColumn, "]");
                Cell currentCell = state.currentSheet.getRow(state.rowNum).createCell(absoluteColumn);
                this.endCellContent(state, null, null, currentCell, null);
                ++state.colNum;
                --this.colSpan;
            }
        } else {
            state.colNum += this.colSpan;
        }
        state.setHandler(this.parent);
    }

    @Override
    public void startContainer(HandlerState state, IContainerContent container) throws BirtException {
        if (!"inline".equals(AbstractRealTableCellHandler.getStyleProperty(container, 63, "block"))) {
            this.lastCellContentsWasBlock = true;
        }
    }

    @Override
    public void endContainer(HandlerState state, IContainerContent container) throws BirtException {
        if (!"inline".equals(AbstractRealTableCellHandler.getStyleProperty(container, 63, "block"))) {
            this.lastCellContentsWasBlock = true;
        }
    }

    private TableContent cellDesignsTableContent() {
        IElement current = this.element;
        while (current != null && !(current instanceof TableContent)) {
            current = current.getParent();
        }
        return (TableContent)current;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        int colSpan = ((ICellContent)this.element).getColSpan();
        int rowSpan = ((ICellContent)this.element).getRowSpan();
        ITableHandler tableHandler = this.getAncestor(ITableHandler.class);
        TableContent myTableContent = this.cellDesignsTableContent();
        if (tableHandler != null && tableHandler.getColumnCount() == colSpan && table.getParent() instanceof CellContent && 1 == ((CellDesign)((CellContent)table.getParent()).getGenerateBy()).getContentCount()) {
            this.containsTable = true;
            this.parentRow = this.getAncestor(AbstractRealTableRowHandler.class);
            this.interruptCell(state, false);
            this.parentRow.interruptRow(state);
            state.setHandler(new NestedTableHandler(this.log, this, table, rowSpan));
            state.getHandler().startTable(state, table);
        } else if (tableHandler != null && myTableContent != null && table.getParent() instanceof CellContent && ((CellContent)table.getParent()).getGenerateBy() instanceof CellDesign && ((CellDesign)((CellContent)table.getParent()).getGenerateBy()).getColumn() + 1 == myTableContent.getColumnCount() && EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), table, "ExcelEmitter.NestedTableInLastCell", false)) {
            colSpan = table.getColumnCount();
            this.containsTable = true;
            this.parentRow = this.getAncestor(AbstractRealTableRowHandler.class);
            this.interruptCell(state, false);
            state.setHandler(new NestedTableHandler(this.log, this, table, rowSpan));
            state.getHandler().startTable(state, table);
        } else if (tableHandler != null && table.getColumnCount() <= colSpan && !(this.element instanceof CellContent)) {
            this.containsTable = true;
            this.parentRow = this.getAncestor(AbstractRealTableRowHandler.class);
            this.interruptCell(state, false);
            this.removeMergedCell(state, state.rowNum, state.colNum);
            NestedTableHandler nestedTableHandler = new NestedTableHandler(this.log, this, table, rowSpan);
            nestedTableHandler.setInserted(true);
            state.setHandler(nestedTableHandler);
            state.getHandler().startTable(state, table);
        } else {
            state.setHandler(new FlattenedTableHandler(this, this.log, this, table));
            state.getHandler().startTable(state, table);
        }
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
        int colSpan = ((ICellContent)this.element).getColSpan();
        ITableHandler tableHandler = this.getAncestor(ITableHandler.class);
        if (tableHandler != null && tableHandler.getColumnCount() == colSpan && list.getParent() instanceof CellContent && 1 == ((CellDesign)((CellContent)list.getParent()).getGenerateBy()).getContentCount()) {
            this.containsTable = true;
            this.parentRow = this.getAncestor(AbstractRealTableRowHandler.class);
            this.interruptCell(state, false);
            this.parentRow.interruptRow(state);
            state.colNum = this.column;
            state.setHandler(new NestedListHandler(this.log, (IHandler)this, list));
            state.getHandler().startList(state, list);
        } else {
            state.setHandler(new FlattenedListHandler(this, this.log, this, list));
            state.getHandler().startList(state, list);
        }
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        String textText = text.getText();
        this.log.debug("text:", textText);
        this.emitContent(state, text, textText, !"inline".equals(AbstractRealTableCellHandler.getStyleProperty(text, 63, "block")));
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        this.emitContent(state, data, data.getValue(), !"inline".equals(AbstractRealTableCellHandler.getStyleProperty(data, 63, "block")));
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        String labelText = label.getText() != null ? label.getText() : label.getLabelText();
        this.log.debug("labelText:", labelText);
        this.emitContent(state, label, labelText, !"inline".equals(AbstractRealTableCellHandler.getStyleProperty(label, 63, "block")));
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        this.emitContent(state, autoText, autoText.getText(), !"inline".equals(AbstractRealTableCellHandler.getStyleProperty(autoText, 63, "block")));
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        this.log.debug("Handling foreign content of type ", foreign.getRawType());
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content(foreign);
            this.contentVisitor.visitChildren(foreign, null);
        }
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        boolean imageCanSpan = false;
        int colSpan = ((ICellContent)this.element).getColSpan();
        ITableHandler tableHandler = this.getAncestor(ITableHandler.class);
        if (tableHandler != null && tableHandler.getColumnCount() == colSpan && image.getParent() instanceof CellContent && 1 == ((CellDesign)((CellContent)image.getParent()).getGenerateBy()).getContentCount()) {
            imageCanSpan = true;
        }
        this.recordImage(state, new Coordinate(state.rowNum, this.column), image, imageCanSpan);
        this.lastElement = image;
    }
}

